/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.displayer;

import java.io.InputStream;
import java.util.Locale;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.fest.assertions.api.Assertions;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.jboss.dashboard.dataset.DataSet;
import org.jboss.dashboard.dataset.DataSetManager;
import org.jboss.dashboard.displayer.DataDisplayerManager;
import org.jboss.dashboard.displayer.chart.BarChartDisplayer;
import org.jboss.dashboard.displayer.chart.BarChartDisplayerType;
import org.jboss.dashboard.function.ScalarFunction;
import org.jboss.dashboard.function.ScalarFunctionManager;
import org.jboss.dashboard.provider.DataFormatterRegistry;
import org.jboss.dashboard.provider.DataLoader;
import org.jboss.dashboard.provider.DataProperty;
import org.jboss.dashboard.provider.DataPropertyFormatter;
import org.jboss.dashboard.provider.DataProvider;
import org.jboss.dashboard.provider.DataProviderManager;
import org.jboss.dashboard.provider.DataProviderType;
import org.jboss.dashboard.provider.csv.CSVDataLoader;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class DataDisplayTest {
    @Inject
    protected BeanManager beanManager;
    @Inject
    protected DataProviderManager dataProviderManager;
    @Inject
    protected DataSetManager dataSetManager;
    @Inject
    protected ScalarFunctionManager scalarFunctionManager;
    @Inject
    protected DataDisplayerManager dataDisplayerManager;
    protected DataSet dataSet;
    protected DataProviderType dataPoviderType;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackage("org.jboss.dashboard.commons.message")).addPackage("org.jboss.dashboard")).addPackage("org.jboss.dashboard.security")).addPackage("org.jboss.dashboard.users")).addPackage("org.jboss.dashboard.database")).addPackage("org.jboss.dashboard.database.hibernate")).addPackage("org.jboss.dashboard.profiler")).addPackage("org.jboss.dashboard.scheduler")).addPackage("org.jboss.dashboard.error")).addPackage("org.jboss.dashboard.filesystem")).addPackage("org.jboss.dashboard.command")).addPackage("org.jboss.dashboard.dataset")).addPackage("org.jboss.dashboard.displayer")).addPackage("org.jboss.dashboard.displayer.annotation")).addPackage("org.jboss.dashboard.displayer.chart")).addPackage("org.jboss.dashboard.displayer.table")).addPackage("org.jboss.dashboard.displayer.nvd3")).addPackage("org.jboss.dashboard.displayer.gauge")).addPackage("org.jboss.dashboard.displayer.ofc2")).addPackage("org.jboss.dashboard.domain")).addPackage("org.jboss.dashboard.domain.date")).addPackage("org.jboss.dashboard.domain.label")).addPackage("org.jboss.dashboard.domain.numeric")).addPackage("org.jboss.dashboard.export")).addPackage("org.jboss.dashboard.function")).addPackage("org.jboss.dashboard.kpi")).addPackage("org.jboss.dashboard.provider")).addPackage("org.jboss.dashboard.provider.csv")).addPackage("org.jboss.dashboard.provider.sql")).addPackage("org.jboss.dashboard.annotation")).addPackage("org.jboss.dashboard.annotation.config")).addPackage("org.jboss.dashboard.pojo")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void setUp() throws Exception {
        CDIBeanLocator.beanManager = this.beanManager;
        this.dataPoviderType = this.dataProviderManager.getProviderTypeByUid("csv");
        DataProvider dataProvider = this.dataProviderManager.createDataProvider();
        CSVDataLoader csvDataLoader = (CSVDataLoader)this.dataPoviderType.createDataLoader();
        dataProvider.setDataLoader((DataLoader)csvDataLoader);
        InputStream dataStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("data.csv");
        this.dataSet = csvDataLoader.load(dataProvider, dataStream);
        this.dataSetManager.registerDataSet(dataProvider, this.dataSet);
    }

    @Test
    public void buildDataSet() {
        Assertions.assertThat((Object)this.dataSet).isNotNull();
        DataProperty propDept = this.dataSet.getPropertyById("department");
        DataProperty propAmount = this.dataSet.getPropertyById("amount");
        Assertions.assertThat((Object)propDept).isNotNull();
        Assertions.assertThat((Object)propAmount).isNotNull();
        BarChartDisplayerType barChartDisplayerType = (BarChartDisplayerType)this.dataDisplayerManager.getDisplayerTypeByUid("barchart");
        BarChartDisplayer barChartDisplayer = (BarChartDisplayer)barChartDisplayerType.createDataDisplayer();
        barChartDisplayer.setDataProvider(this.dataSet.getDataProvider());
        barChartDisplayer.setDomainProperty(propDept);
        barChartDisplayer.setRangeProperty(propAmount);
        ScalarFunction scalarFunction = this.scalarFunctionManager.getScalarFunctionByCode("sum");
        barChartDisplayer.setRangeScalarFunction(scalarFunction);
        DataSet xyDataSet = barChartDisplayer.buildXYDataSet();
        Assertions.assertThat((xyDataSet.getProperties().length == 2 ? 1 : 0) != 0);
        Assertions.assertThat((xyDataSet.getRowCount() == 5 ? 1 : 0) != 0);
        Locale locale = Locale.ENGLISH;
        DataFormatterRegistry dataFormatterRegistry = DataFormatterRegistry.lookup();
        DataPropertyFormatter formatterDept = dataFormatterRegistry.getPropertyFormatter("department");
        DataPropertyFormatter formatterAmount = dataFormatterRegistry.getPropertyFormatter("amount");
        String value = formatterDept.formatValue(propDept, xyDataSet.getValueAt(0, 0), locale);
        Assertions.assertThat((String)value).isEqualTo((Object)"Engineering");
        value = formatterDept.formatValue(propDept, xyDataSet.getValueAt(1, 0), locale);
        Assertions.assertThat((String)value).isEqualTo((Object)"Services");
        value = formatterDept.formatValue(propDept, xyDataSet.getValueAt(2, 0), locale);
        Assertions.assertThat((String)value).isEqualTo((Object)"Sales");
        value = formatterDept.formatValue(propDept, xyDataSet.getValueAt(3, 0), locale);
        Assertions.assertThat((String)value).isEqualTo((Object)"Support");
        value = formatterDept.formatValue(propDept, xyDataSet.getValueAt(4, 0), locale);
        Assertions.assertThat((String)value).isEqualTo((Object)"Management");
        value = formatterAmount.formatValue(propAmount, xyDataSet.getValueAt(0, 1), locale);
        Assertions.assertThat((String)value).isEqualTo((Object)"7,650.162");
        value = formatterAmount.formatValue(propAmount, xyDataSet.getValueAt(1, 1), locale);
        Assertions.assertThat((String)value).isEqualTo((Object)"2,504.5");
        value = formatterAmount.formatValue(propAmount, xyDataSet.getValueAt(2, 1), locale);
        Assertions.assertThat((String)value).isEqualTo((Object)"3,213.53");
        value = formatterAmount.formatValue(propAmount, xyDataSet.getValueAt(3, 1), locale);
        Assertions.assertThat((String)value).isEqualTo((Object)"3,345.6");
        value = formatterAmount.formatValue(propAmount, xyDataSet.getValueAt(4, 1), locale);
        Assertions.assertThat((String)value).isEqualTo((Object)"6,017.47");
    }
}

