/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.showcase;

import java.io.File;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.jboss.dashboard.ui.controller.CommandRequest;

public class SalesDashboardData {
    private static String[] DIC_PIPELINE = new String[]{"EARLY", "STANDBY", "ADVANCED"};
    private static String[] DIC_STATUS = new String[]{"CONTACTED", "STANDBY", "DEMO", "SHORT LISTED", "LOST", "WIN", "VERBAL COMMITMENT", "QUALIFIED"};
    private static String[] DIC_COUNTRIES = new String[]{"United States", "China", "Japan", "Germany", "France", "United Kingdom", "Brazil", "Italy", "India", "Canada", "Russia", "Spain", "Australia", "Mexico", "South Korea", "Netherlands", "Turkey", "Indonesia", "Switzerland", "Poland", "Belgium", "Sweden", "Saudi Arabia", "Norway"};
    private static String[] DIC_PRODUCT = new String[]{"PRODUCT 1", "PRODUCT 2", "PRODUCT 3", "PRODUCT 4", "PRODUCT 5", "PRODUCT 6", "PRODUCT 7", "PRODUCT 8", "PRODUCT 8", "PRODUCT 10", "PRODUCT 11"};
    private static String[] DIC_SALES_PERSON = new String[]{"Roxie Foraker", "Jamie Gilbeau", "Nita Marling", "Darryl Innes", "Julio Burdge", "Neva Hunger", "Kathrine Janas", "Jerri Preble"};
    private static String[] DIC_CUSTOMER = new String[]{"Company 1", "Company 2", "Company 3", "Company 3", "Company 4", "Company 5", "Company 6", "Company 7", "Company 8", "Company 9"};
    private static String[] DIC_SOURCE = new String[]{"Customer", "Reference", "Personal contact", "Partner", "Website", "Lead generation", "Event"};
    private static double MAX_AMOUNT = 15000.0;
    private static double MIN_AMOUNT = 8000.0;
    private static double AVG_CLOSING_DAYS = 90.0;
    private static String CSV_SEPARATOR = ";";
    private static int START_ID_VALUES = 10000;
    private NumberFormat numberFormat = DecimalFormat.getInstance(Locale.US);
    private DateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
    private Random random = new Random(System.currentTimeMillis());

    private Date buildDate(int month, int year) {
        Calendar c = Calendar.getInstance();
        c.set(5, this.random.nextInt(28));
        c.set(1, year);
        c.set(2, month - 1);
        c.set(11, this.random.nextInt(24));
        c.set(12, this.random.nextInt(60));
        return c.getTime();
    }

    private Date addDates(Date d, int days) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.add(5, days);
        return c.getTime();
    }

    private String randomValue(String[] dic) {
        return dic[this.random.nextInt(dic.length)];
    }

    private String format(double d) {
        return this.numberFormat.format(d);
    }

    private String format(Date d) {
        return this.dateFormat.format(d);
    }

    private int getParam(String param, CommandRequest req, int defaultValue) {
        String paramStr = req.getRequestObject().getParameter(param);
        if (paramStr == null || paramStr.trim().equals("")) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(paramStr);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public List<Opportunity> generateRandomOpportunities(int nOpportunitiesPerMonth, int yearStart, int yearEnd) {
        ArrayList<Opportunity> opportunities = new ArrayList<Opportunity>();
        for (int year = yearStart; year <= yearEnd; ++year) {
            for (int month = 1; month <= 12; ++month) {
                for (int i = 0; i < nOpportunitiesPerMonth; ++i) {
                    Opportunity opportunity = new Opportunity();
                    opportunity.amount = MIN_AMOUNT + this.random.nextDouble() * (MAX_AMOUNT - MIN_AMOUNT);
                    opportunity.creationDate = this.buildDate(month, year);
                    opportunity.closingDate = this.addDates(opportunity.creationDate, (int)(AVG_CLOSING_DAYS + this.random.nextDouble() * AVG_CLOSING_DAYS * 0.5));
                    opportunity.pipeline = this.randomValue(DIC_PIPELINE);
                    opportunity.status = this.randomValue(DIC_STATUS);
                    opportunity.country = this.randomValue(DIC_COUNTRIES);
                    opportunity.customer = this.randomValue(DIC_CUSTOMER);
                    opportunity.product = this.randomValue(DIC_PRODUCT);
                    opportunity.salesPerson = this.randomValue(DIC_SALES_PERSON);
                    opportunity.probability = this.random.nextDouble() * 100.0;
                    opportunity.expectedAmount = opportunity.amount * opportunity.probability;
                    opportunity.source = this.randomValue(DIC_SOURCE);
                    opportunity.color = opportunity.probability < 25.0 ? "RED" : (opportunity.probability < 50.0 ? "GREY" : (opportunity.probability < 75.0 ? "YELLOW" : "GREEN"));
                    opportunities.add(opportunity);
                }
            }
        }
        return opportunities;
    }

    public String buildCSV(List<Opportunity> opportunities) {
        StringBuffer sb = new StringBuffer();
        sb.append("Amount" + CSV_SEPARATOR + "Creation date" + CSV_SEPARATOR + "Closing date" + CSV_SEPARATOR + "Pipeline" + CSV_SEPARATOR + "Status" + CSV_SEPARATOR + "Customer" + CSV_SEPARATOR + "Country" + CSV_SEPARATOR + "Product" + CSV_SEPARATOR + "Sales person" + CSV_SEPARATOR + "Probability" + CSV_SEPARATOR + "Source" + CSV_SEPARATOR + "Expected amount" + CSV_SEPARATOR + "Color");
        sb.append("\n");
        int idOpportunity = START_ID_VALUES;
        for (Opportunity opportunity : opportunities) {
            sb.append(this.format(opportunity.amount) + CSV_SEPARATOR);
            sb.append(this.format(opportunity.creationDate) + CSV_SEPARATOR);
            sb.append(this.format(opportunity.closingDate) + CSV_SEPARATOR);
            sb.append(opportunity.pipeline + CSV_SEPARATOR);
            sb.append(opportunity.status + CSV_SEPARATOR);
            sb.append(opportunity.customer + CSV_SEPARATOR);
            sb.append(opportunity.country + CSV_SEPARATOR);
            sb.append(opportunity.product + CSV_SEPARATOR);
            sb.append(opportunity.salesPerson + CSV_SEPARATOR);
            sb.append(this.format(opportunity.probability) + CSV_SEPARATOR);
            sb.append(opportunity.source + CSV_SEPARATOR);
            sb.append(this.format(opportunity.expectedAmount) + CSV_SEPARATOR);
            sb.append(opportunity.color);
            sb.append("\n");
            ++idOpportunity;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        int opportunitiesPerMonth = 30;
        int startYear = 2012;
        int endYear = 2016;
        SalesDashboardData salesDashboardData = new SalesDashboardData();
        List<Opportunity> opportunities = salesDashboardData.generateRandomOpportunities(opportunitiesPerMonth, startYear, endYear);
        String csv = salesDashboardData.buildCSV(opportunities);
        FileUtils.write((File)new File("sales_dashboard_data.csv"), (CharSequence)csv);
    }

    public static class Opportunity {
        public String pipeline;
        public String status;
        public String country;
        public String product;
        public String customer;
        public String salesPerson;
        double amount;
        double probability;
        double expectedAmount;
        public Date creationDate;
        public Date closingDate;
        public String source;
        public String color;
    }
}

