/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.showcase;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.jboss.dashboard.Application;
import org.jboss.dashboard.DataDisplayerServices;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.jboss.dashboard.export.ImportManager;
import org.jboss.dashboard.export.ImportResults;
import org.jboss.dashboard.kpi.KPI;
import org.jboss.dashboard.profiler.CodeBlockTrace;
import org.jboss.dashboard.test.KPITestMethodGenerator;
import org.jboss.dashboard.test.MavenProjectHelper;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;

public class ShowcaseKPITestsGenerator {
    public static void main(String[] args) throws Exception {
        WeldContainer container = new Weld().initialize();
        CDIBeanLocator.beanManager = container.getBeanManager();
        CodeBlockTrace.RUNTIME_CONTRAINTS_ENABLED = false;
        File rootDir = MavenProjectHelper.getModuleDir((String)"dashboard-samples");
        File webAppDir = new File(rootDir, "src/main/webapp");
        Application.lookup().setBaseAppDirectory(webAppDir.getAbsolutePath());
        File kpisFile = new File(webAppDir, "WEB-INF/etc/appdata/initialData/showcaseKPIs.xml");
        FileInputStream is = new FileInputStream(kpisFile);
        ImportManager importManager = DataDisplayerServices.lookup().getImportManager();
        ImportResults context = importManager.parse((InputStream)is);
        for (KPI kpi : context.getKPIs()) {
            if (kpi.getCode().equals("kpi_30771353684719633") || kpi.getCode().equals("kpi_29761353668431694")) continue;
            String method = KPITestMethodGenerator.generateKPITestMethod(kpi);
            System.out.println(method);
        }
    }
}

