/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.security;

import java.security.Permission;
import java.security.PermissionCollection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.security.auth.Subject;
import org.jboss.dashboard.security.AccessController;
import org.jboss.dashboard.security.Policy;

@ApplicationScoped
public class DefaultAccessController
implements AccessController {
    @Inject
    private Policy securityPolicy;

    @Override
    public Policy getPolicy() {
        return this.securityPolicy;
    }

    @Override
    public void checkPermission(Subject usr, Permission perm) {
        if (this.hasPermission(usr, perm)) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Permission ");
        buf.append(perm.toString()).append(" ");
        buf.append("not granted for the Subject.");
        throw new SecurityException(buf.toString());
    }

    @Override
    public boolean hasPermission(Subject usr, Permission perm) {
        PermissionCollection pc = this.securityPolicy.getPermissions(usr);
        return pc.implies(perm);
    }
}

