/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.displayer.google;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jboss.dashboard.LocaleManager;
import org.jboss.dashboard.annotation.Install;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.displayer.AbstractDataDisplayerRenderer;
import org.jboss.dashboard.displayer.DataDisplayer;
import org.jboss.dashboard.displayer.DataDisplayerFeature;
import org.jboss.dashboard.displayer.DataDisplayerType;
import org.jboss.dashboard.displayer.annotation.BarChart;
import org.jboss.dashboard.displayer.annotation.LineChart;
import org.jboss.dashboard.displayer.annotation.MapChart;
import org.jboss.dashboard.displayer.annotation.PieChart;
import org.jboss.dashboard.displayer.chart.AbstractChartDisplayer;
import org.jboss.dashboard.displayer.chart.AbstractXAxisDisplayer;
import org.jboss.dashboard.displayer.chart.LineChartDisplayer;
import org.jboss.dashboard.displayer.chart.PieChartDisplayer;
import org.jboss.dashboard.ui.UIServices;

@Install
@MapChart
@BarChart
@PieChart
@LineChart
public class GoogleDisplayerRenderer
extends AbstractDataDisplayerRenderer {
    public static final String UID = "google";
    @Inject
    @Config(value="false")
    protected boolean enabled;
    @Inject
    @Config(value="https://www.google.com/jsapi")
    protected String jsApiUrl;
    @Inject
    @Config(value="")
    protected String[] barChartTypes;
    @Inject
    @Config(value="")
    protected String barChartDefault;
    @Inject
    @Config(value="")
    protected String[] pieChartTypes;
    @Inject
    @Config(value="")
    protected String pieChartDefault;
    @Inject
    @Config(value="")
    protected String[] lineChartTypes;
    @Inject
    @Config(value="")
    protected String lineChartDefault;
    @Inject
    @Config(value="GeoChart, GeoMap")
    protected String[] mapChartTypes;
    @Inject
    @Config(value="GeoChart")
    protected String mapChartDefault;
    protected List<DataDisplayerFeature> featuresSupported;
    protected Map<String, List<String>> availableChartTypes;
    protected Map<String, String> defaultChartTypes;
    @Inject
    protected LocaleManager localeManager;

    @PostConstruct
    protected void init() {
        this.featuresSupported = new ArrayList<DataDisplayerFeature>();
        this.featuresSupported.add(DataDisplayerFeature.ALIGN_CHART);
        this.featuresSupported.add(DataDisplayerFeature.SHOW_TITLE);
        this.featuresSupported.add(DataDisplayerFeature.SET_CHART_TYPE);
        this.featuresSupported.add(DataDisplayerFeature.SET_CHART_WIDTH);
        this.featuresSupported.add(DataDisplayerFeature.SET_CHART_HEIGHT);
        this.featuresSupported.add(DataDisplayerFeature.ROUND_TO_INTEGER);
        this.featuresSupported.add(DataDisplayerFeature.SET_FOREGRND_COLOR);
        this.availableChartTypes = new HashMap<String, List<String>>();
        this.availableChartTypes.put("barchart", Arrays.asList(this.barChartTypes));
        this.availableChartTypes.put("piechart", Arrays.asList(this.pieChartTypes));
        this.availableChartTypes.put("linechart", Arrays.asList(this.lineChartTypes));
        this.availableChartTypes.put("mapchart", Arrays.asList(this.mapChartTypes));
        this.defaultChartTypes = new HashMap<String, String>();
        this.defaultChartTypes.put("barchart", this.barChartDefault);
        this.defaultChartTypes.put("piechart", this.pieChartDefault);
        this.defaultChartTypes.put("linechart", this.lineChartDefault);
        this.defaultChartTypes.put("mapchart", this.mapChartDefault);
        if (this.enabled) {
            UIServices.lookup().getJsIncluder().addJsHeaderFile(this.jsApiUrl);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getUid() {
        return UID;
    }

    public String getDescription(Locale l) {
        try {
            ResourceBundle i18n = this.localeManager.getBundle("org.jboss.dashboard.displayer.google.messages", l);
            return i18n.getString("google.name");
        }
        catch (Exception e) {
            return "SVG Charts (Google)";
        }
    }

    public boolean isFeatureSupported(DataDisplayer displayer, DataDisplayerFeature feature) {
        if (displayer instanceof PieChartDisplayer && feature.equals((Object)DataDisplayerFeature.SHOW_LEGEND)) {
            return true;
        }
        if (displayer instanceof LineChartDisplayer && feature.equals((Object)DataDisplayerFeature.SHOW_LINES_AREA)) {
            return true;
        }
        if (displayer instanceof LineChartDisplayer && feature.equals((Object)DataDisplayerFeature.SET_FOREGRND_COLOR)) {
            return true;
        }
        return this.featuresSupported.contains(feature);
    }

    public List<String> getAvailableChartTypes(DataDisplayer displayer) {
        DataDisplayerType displayerType = displayer.getDataDisplayerType();
        return this.availableChartTypes.get(displayerType.getUid());
    }

    public String getDefaultChartType(DataDisplayer displayer) {
        DataDisplayerType displayerType = displayer.getDataDisplayerType();
        return this.defaultChartTypes.get(displayerType.getUid());
    }

    public String getChartTypeDescription(String chartType, Locale locale) {
        try {
            ResourceBundle i18n = this.localeManager.getBundle("org.jboss.dashboard.displayer.google.messages", locale);
            return i18n.getString("google.type." + chartType.toLowerCase());
        }
        catch (Exception e) {
            return chartType;
        }
    }

    public void setDefaultSettings(DataDisplayer displayer) {
        if (displayer instanceof AbstractChartDisplayer) {
            AbstractChartDisplayer chartDisplayer = (AbstractChartDisplayer)displayer;
            chartDisplayer.setMarginLeft(80);
            chartDisplayer.setMarginBottom(100);
        }
        if (displayer instanceof AbstractXAxisDisplayer) {
            AbstractXAxisDisplayer xAxisDisplayer = (AbstractXAxisDisplayer)displayer;
            xAxisDisplayer.setLabelAngleXAxis(-45);
        }
        if (displayer instanceof LineChartDisplayer) {
            LineChartDisplayer lineChartDisplayer = (LineChartDisplayer)displayer;
            lineChartDisplayer.setShowLinesArea(true);
        }
    }
}

