/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.displayer.nvd3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jboss.dashboard.annotation.Install;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.displayer.AbstractDataDisplayerRenderer;
import org.jboss.dashboard.displayer.DataDisplayer;
import org.jboss.dashboard.displayer.DataDisplayerFeature;
import org.jboss.dashboard.displayer.DataDisplayerType;
import org.jboss.dashboard.displayer.annotation.BarChart;
import org.jboss.dashboard.displayer.annotation.LineChart;
import org.jboss.dashboard.displayer.annotation.PieChart;
import org.jboss.dashboard.displayer.chart.AbstractChartDisplayer;
import org.jboss.dashboard.displayer.chart.AbstractXAxisDisplayer;
import org.jboss.dashboard.displayer.chart.LineChartDisplayer;
import org.jboss.dashboard.displayer.chart.PieChartDisplayer;

@Install
@BarChart
@PieChart
@LineChart
public class NVD3DisplayerRenderer
extends AbstractDataDisplayerRenderer {
    public static final String UID = "nvd3";
    @Inject
    @Config(value="nvd3")
    protected String uid;
    @Inject
    @Config(value="")
    public String[] barChartTypes;
    @Inject
    @Config(value="")
    public String barChartDefault;
    @Inject
    @Config(value="")
    public String[] pieChartTypes;
    @Inject
    @Config(value="")
    public String pieChartDefault;
    @Inject
    @Config(value="")
    public String[] lineChartTypes;
    @Inject
    @Config(value="")
    public String lineChartDefault;
    List<DataDisplayerFeature> featuresSupported;
    Map<String, List<String>> availableChartTypes;
    Map<String, String> defaultChartTypes;

    @PostConstruct
    protected void init() {
        this.featuresSupported = new ArrayList<DataDisplayerFeature>();
        this.featuresSupported.add(DataDisplayerFeature.ALIGN_CHART);
        this.featuresSupported.add(DataDisplayerFeature.SHOW_TITLE);
        this.featuresSupported.add(DataDisplayerFeature.SHOW_HIDE_LABELS);
        this.featuresSupported.add(DataDisplayerFeature.SET_CHART_WIDTH);
        this.featuresSupported.add(DataDisplayerFeature.SET_CHART_HEIGHT);
        this.featuresSupported.add(DataDisplayerFeature.SET_LABELS_ANGLE);
        this.featuresSupported.add(DataDisplayerFeature.SET_MARGIN_BOTTOM);
        this.featuresSupported.add(DataDisplayerFeature.SET_MARGIN_TOP);
        this.featuresSupported.add(DataDisplayerFeature.SET_MARGIN_LEFT);
        this.featuresSupported.add(DataDisplayerFeature.SET_MARGIN_RIGHT);
        this.availableChartTypes = new HashMap<String, List<String>>();
        this.availableChartTypes.put("barchart", Arrays.asList(this.barChartTypes));
        this.availableChartTypes.put("piechart", Arrays.asList(this.pieChartTypes));
        this.availableChartTypes.put("linechart", Arrays.asList(this.lineChartTypes));
        this.defaultChartTypes = new HashMap<String, String>();
        this.defaultChartTypes.put("barchart", this.barChartDefault);
        this.defaultChartTypes.put("piechart", this.pieChartDefault);
        this.defaultChartTypes.put("linechart", this.lineChartDefault);
    }

    public String getUid() {
        return this.uid;
    }

    public String getDescription(Locale l) {
        try {
            ResourceBundle i18n = ResourceBundle.getBundle("org.jboss.dashboard.displayer.nvd3.messages", l);
            return i18n.getString("nvd3.name");
        }
        catch (Exception e) {
            return "SVG Charts (NVD3)";
        }
    }

    public boolean isFeatureSupported(DataDisplayer displayer, DataDisplayerFeature feature) {
        if (displayer instanceof PieChartDisplayer && feature.equals((Object)DataDisplayerFeature.SHOW_LEGEND)) {
            return true;
        }
        if (displayer instanceof LineChartDisplayer && feature.equals((Object)DataDisplayerFeature.SHOW_LINES_AREA)) {
            return true;
        }
        if (displayer instanceof LineChartDisplayer && feature.equals((Object)DataDisplayerFeature.SET_FOREGRND_COLOR)) {
            return true;
        }
        return this.featuresSupported.contains(feature);
    }

    public List<String> getAvailableChartTypes(DataDisplayer displayer) {
        DataDisplayerType displayerType = displayer.getDataDisplayerType();
        return this.availableChartTypes.get(displayerType.getUid());
    }

    public String getDefaultChartType(DataDisplayer displayer) {
        DataDisplayerType displayerType = displayer.getDataDisplayerType();
        return this.defaultChartTypes.get(displayerType.getUid());
    }

    public String getChartTypeDescription(String chartType, Locale locale) {
        try {
            ResourceBundle i18n = ResourceBundle.getBundle("org.jboss.dashboard.displayer.nvd3.messages", locale);
            return i18n.getString("nvd3.type." + chartType);
        }
        catch (Exception e) {
            return chartType;
        }
    }

    public void setDefaultSettings(DataDisplayer displayer) {
        if (displayer instanceof AbstractChartDisplayer) {
            AbstractChartDisplayer chartDisplayer = (AbstractChartDisplayer)displayer;
            chartDisplayer.setMarginLeft(80);
            chartDisplayer.setMarginBottom(100);
        }
        if (displayer instanceof AbstractXAxisDisplayer) {
            AbstractXAxisDisplayer xAxisDisplayer = (AbstractXAxisDisplayer)displayer;
            xAxisDisplayer.setLabelAngleXAxis(-45);
        }
        if (displayer instanceof LineChartDisplayer) {
            LineChartDisplayer lineChartDisplayer = (LineChartDisplayer)displayer;
            lineChartDisplayer.setShowLinesArea(true);
        }
    }
}

