/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.deployer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractParsingDeployerWithOutput;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.FileMatcher;
import org.jboss.deployers.vfs.spi.deployer.SecurityActions;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVFSParsingDeployer<T>
extends AbstractParsingDeployerWithOutput<T>
implements FileMatcher {
    private static final String ALT_MAPPINGS_MAP_KEY = "AltMappingsMap";
    private boolean allowMultipleFiles;

    public AbstractVFSParsingDeployer(Class<T> output) {
        super(output);
    }

    @Override
    public boolean isDeployable(VirtualFile file) {
        String fileName = file.getName();
        String suffix = this.getSuffix();
        if (suffix == null) {
            return this.getNames() != null && this.getNames().contains(fileName);
        }
        return fileName.endsWith(suffix);
    }

    protected boolean accepts(VFSDeploymentUnit unit) throws DeploymentException {
        return true;
    }

    protected boolean accepts(DeploymentUnit unit) throws DeploymentException {
        if (!(unit instanceof VFSDeploymentUnit)) {
            this.log.trace((Object)("Not a vfs deployment: " + unit.getName()));
            return false;
        }
        return this.accepts((VFSDeploymentUnit)unit);
    }

    protected InputStream openStreamAndValidate(VirtualFile file) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        InputStream inputStream = SecurityActions.openStream(file);
        if (inputStream == null) {
            throw new IOException("Null file stream: " + file);
        }
        return inputStream;
    }

    protected static Map<String, Class<?>> getAltMappings(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null deployment unit");
        }
        return (Map)unit.getAttachment(ALT_MAPPINGS_MAP_KEY, Map.class);
    }

    protected VirtualFile getMetadataFile(VFSDeploymentUnit unit, Class<?> altExpectedClass, String originalName, boolean checkMetaDataFile) {
        String altPrefix = altExpectedClass != null ? altExpectedClass.getName() : originalName;
        VirtualFile file = (VirtualFile)unit.getAttachment(String.valueOf(altPrefix) + ".altDD", VirtualFile.class);
        if (file != null && altExpectedClass != null) {
            Map<String, Class<?>> altMappingsMap = AbstractVFSParsingDeployer.getAltMappings(unit);
            if (altMappingsMap == null) {
                altMappingsMap = new HashMap();
                unit.addAttachment(ALT_MAPPINGS_MAP_KEY, altMappingsMap, Map.class);
            }
            altMappingsMap.put(file.getName(), altExpectedClass);
        }
        if (checkMetaDataFile && file == null) {
            file = unit.getMetaDataFile(originalName);
        }
        return file;
    }

    protected Class<?> matchFileToClass(DeploymentUnit unit, String fileName) {
        Map<String, Class<?>> altMappingsMap = AbstractVFSParsingDeployer.getAltMappings(unit);
        return altMappingsMap != null ? altMappingsMap.get(fileName) : null;
    }

    protected T parse(DeploymentUnit unit, String name, T root) throws Exception {
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        VirtualFile file = this.getMetadataFile(vfsDeploymentUnit, this.getOutput(), name, true);
        if (file == null) {
            return null;
        }
        return this.parseAndInit(vfsDeploymentUnit, file, root);
    }

    protected T parse(DeploymentUnit unit, Set<String> names, T root) throws Exception {
        if (names == null || names.isEmpty()) {
            throw new IllegalArgumentException("Null or empty names.");
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        HashSet<String> missingFiles = new HashSet<String>();
        for (String name : names) {
            VirtualFile file = this.getMetadataFile(vfsDeploymentUnit, this.matchFileToClass(unit, name), name, true);
            if (file != null) {
                files.add(file);
                continue;
            }
            missingFiles.add(name);
        }
        if (missingFiles.size() == names.size()) {
            return null;
        }
        return this.mergeFiles(vfsDeploymentUnit, root, files, missingFiles);
    }

    protected T parse(DeploymentUnit unit, String name, String suffix, T root) throws Exception {
        VFSDeploymentUnit vfsDeploymentUnit;
        VirtualFile file;
        if (name == null && this.isIncludeDeploymentFile()) {
            name = unit.getName();
        }
        if ((file = this.getMetadataFile(vfsDeploymentUnit = (VFSDeploymentUnit)unit, this.getOutput(), name, false)) != null) {
            return this.parseAndInit(vfsDeploymentUnit, file, root);
        }
        List<VirtualFile> files = vfsDeploymentUnit.getMetaDataFiles(name, suffix);
        switch (files.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.parseAndInit(vfsDeploymentUnit, files.get(0), root);
            }
        }
        return this.handleMultipleFiles(vfsDeploymentUnit, root, files);
    }

    protected T parseAndInit(VFSDeploymentUnit unit, VirtualFile file, T root) throws Exception {
        T result = this.parse(unit, file, root);
        if (result != null) {
            this.init(unit, result, file);
        }
        return result;
    }

    protected T parse(DeploymentUnit unit, Set<String> names, String suffix, T root) throws Exception {
        if (names == null || names.isEmpty()) {
            throw new IllegalArgumentException("Null or empty names.");
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        HashSet<String> missingFiles = new HashSet<String>();
        for (String name : names) {
            VirtualFile file = this.getMetadataFile(vfsDeploymentUnit, this.matchFileToClass(unit, name), name, false);
            if (file == null) {
                List<VirtualFile> matched = vfsDeploymentUnit.getMetaDataFiles(name, suffix);
                if (matched != null && !matched.isEmpty()) {
                    files.addAll(matched);
                    continue;
                }
                missingFiles.add(name);
                continue;
            }
            files.add(file);
        }
        if (missingFiles.size() == names.size()) {
            return null;
        }
        return this.mergeFiles(vfsDeploymentUnit, root, files, missingFiles);
    }

    protected T mergeFiles(VFSDeploymentUnit unit, T root, List<VirtualFile> files, Set<String> missingFiles) throws Exception {
        return null;
    }

    protected T handleMultipleFiles(VFSDeploymentUnit unit, T root, List<VirtualFile> files) throws Exception {
        if (!this.allowsMultipleFiles(files)) {
            throw new IllegalArgumentException("Multiple matching files not allowed: " + files);
        }
        for (VirtualFile file : files) {
            T result = this.parse(unit, file, root);
            if (result == null) continue;
            this.init(unit, result, file);
            unit.addAttachment(file.toURL().toString(), result, this.getOutput());
        }
        return null;
    }

    protected boolean allowsMultipleFiles(List<VirtualFile> files) {
        return this.allowMultipleFiles;
    }

    protected abstract T parse(VFSDeploymentUnit var1, VirtualFile var2, T var3) throws Exception;

    protected void init(VFSDeploymentUnit unit, T metaData, VirtualFile file) throws Exception {
    }

    public void setAllowMultipleFiles(boolean allowMultipleFiles) {
        this.allowMultipleFiles = allowMultipleFiles;
    }
}

