/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.deployer;

import java.util.HashMap;
import java.util.Map;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSParsingDeployer;
import org.jboss.deployers.vfs.spi.deployer.UnmarshallerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnmarshallerFactoryDeployer<T, U>
extends AbstractVFSParsingDeployer<T> {
    static String FIXUP_BASE_URIS = "http://apache.org/xml/features/xinclude/fixup-base-uris";
    static String FIXUP_LANGUAGE = "http://apache.org/xml/features/xinclude/fixup-language";
    private boolean useDefaultFeatures = true;
    private Map<String, U> features;

    protected UnmarshallerFactoryDeployer(Class<T> output) {
        super(output);
    }

    protected abstract UnmarshallerFactory<U> createUnmarshallerFactory();

    public void start() throws Exception {
        Map<String, U> features = this.getFeatures();
        if (this.isUseDefaultFeatures()) {
            if (features == null) {
                features = new HashMap<String, U>();
            }
            if (!features.containsKey(FIXUP_BASE_URIS)) {
                features.put(FIXUP_BASE_URIS, this.fromString("false"));
            }
            if (!features.containsKey(FIXUP_LANGUAGE)) {
                features.put(FIXUP_LANGUAGE, this.fromString("false"));
            }
        }
        if (features != null && !features.isEmpty()) {
            UnmarshallerFactory<U> unmarshallerFactory = this.createUnmarshallerFactory();
            if (unmarshallerFactory == null) {
                throw new IllegalArgumentException("Unmarshaller factory cannot be null.");
            }
            for (Map.Entry<String, U> entry : features.entrySet()) {
                unmarshallerFactory.setFeature(entry.getKey(), entry.getValue());
            }
        }
    }

    protected abstract U fromString(String var1);

    public boolean isUseDefaultFeatures() {
        return this.useDefaultFeatures;
    }

    public void setUseDefaultFeatures(boolean useDefaultFeatures) {
        this.useDefaultFeatures = useDefaultFeatures;
    }

    public Map<String, U> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, U> features) {
        this.features = features;
    }
}

