/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.modified;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.jboss.deployers.vfs.spi.structure.modified.StructureCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStructureCache<T>
implements StructureCache<T> {
    private Map<String, T> map = new ConcurrentHashMap<String, T>();

    @Override
    public void initializeCache(String pathName) {
    }

    @Override
    public T putCacheValue(String pathName, T value) {
        return this.map.put(pathName, value);
    }

    @Override
    public T getCacheValue(String pathName) {
        return this.map.get(pathName);
    }

    @Override
    public Set<String> getLeaves(String pathName) {
        HashSet<String> result = null;
        Pattern pattern = Pattern.compile(String.valueOf(pathName) + "/[^/]+");
        for (String key : this.map.keySet()) {
            if (!pattern.matcher(key).matches()) continue;
            if (result == null) {
                result = new HashSet<String>();
            }
            result.add(key);
        }
        if (result != null) {
            return result;
        }
        return this.map.containsKey(pathName) ? Collections.emptySet() : null;
    }

    @Override
    public void invalidateCache(String pathName) {
        this.removeCache(pathName);
    }

    @Override
    public void removeCache(String pathName) {
        Iterator<Map.Entry<String, T>> iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, T> entry = iter.next();
            if (!entry.getKey().startsWith(pathName)) continue;
            iter.remove();
        }
    }

    @Override
    public void flush() {
        this.map.clear();
    }
}

