/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.modified;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.vfs.spi.structure.modified.StructureCache;
import org.jboss.virtual.plugins.vfs.helpers.PathTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeStructureCache<T>
implements StructureCache<T> {
    private final Node<T> root = this.createRoot();

    protected Node<T> createRoot() {
        return new Node("", this.getDefaultValue(), null);
    }

    protected T getDefaultValue() {
        return null;
    }

    @Override
    public void initializeCache(String pathName) {
        this.initializeNode(pathName);
    }

    @Override
    public T putCacheValue(String pathName, T value) {
        Node<T> node = this.getNode(pathName);
        if (node == null) {
            node = this.initializeNode(pathName);
        }
        T previous = node.getValue();
        node.setValue(value);
        return previous;
    }

    @Override
    public T getCacheValue(String pathName) {
        Node<T> node = this.getNode(pathName);
        return node != null ? (T)node.getValue() : null;
    }

    @Override
    public Set<String> getLeaves(String pathName) {
        Node<T> node = this.getNode(pathName);
        return node != null ? node.getChildrenNames() : null;
    }

    @Override
    public void invalidateCache(String pathName) {
        this.removeCache(pathName);
    }

    @Override
    public void removeCache(String pathName) {
        Node<T> node = this.getNode(pathName);
        if (node != null) {
            Node<T> parent = node.getParent();
            if (parent != null) {
                parent.removeChild(node);
            } else {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Node<T> node = this.root;
        synchronized (node) {
            this.root.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node<T> getNode(String path) {
        List tokens = PathTokenizer.getTokens((String)path);
        Node<T> node = this.root;
        synchronized (node) {
            Node<T> node2 = this.root;
            for (String token : tokens) {
                if ((node2 = node2.getChild(token)) == null) break;
            }
            return node2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node<T> initializeNode(String pathName) {
        List tokens = PathTokenizer.getTokens((String)pathName);
        Node<T> node = this.root;
        synchronized (node) {
            Node<Object> node2 = this.root;
            boolean newNode = false;
            for (String token : tokens) {
                if (newNode) {
                    node2 = new Node(token, this.getDefaultValue(), node2);
                    continue;
                }
                Node<Object> child = node2.getChild(token);
                if (child == null) {
                    child = new Node(token, this.getDefaultValue(), node2);
                    newNode = true;
                }
                node2 = child;
            }
            return node2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Node<U> {
        private String name;
        private String fullName;
        private Node<U> parent;
        private U value;
        private Map<String, Node<U>> children;
        private Set<String> names;

        private Node(String name, U value, Node<U> parent) {
            this.name = name;
            this.value = value;
            this.parent = parent;
            if (parent != null) {
                super.addChild(this);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getFullName() {
            if (this.fullName == null) {
                Node<U> parent = this.getParent();
                this.fullName = parent != null && parent.getParent() != null ? String.valueOf(parent.getFullName()) + "/" + this.getName() : this.getName();
            }
            return this.fullName;
        }

        public U getValue() {
            return this.value;
        }

        public void setValue(U value) {
            this.value = value;
        }

        public Node<U> getParent() {
            return this.parent;
        }

        private void addChild(Node<U> node) {
            if (this.children == null) {
                this.children = new HashMap<String, Node<U>>();
            }
            this.children.put(node.getName(), node);
            if (this.names != null) {
                this.names.add(node.getFullName());
            }
        }

        public synchronized void removeChild(Node<U> node) {
            if (this.children == null) {
                return;
            }
            this.children.remove(node.getName());
            if (this.names != null) {
                this.names.remove(node.getFullName());
            }
            if (this.children.isEmpty()) {
                this.children = null;
            }
            if (this.names != null && this.names.isEmpty()) {
                this.names = null;
            }
        }

        void clear() {
            this.value = null;
            this.children = null;
            this.names = null;
        }

        public Node<U> getChild(String name) {
            return this.children != null ? this.children.get(name) : null;
        }

        public synchronized Set<String> getChildrenNames() {
            if (this.children == null) {
                return Collections.emptySet();
            }
            if (this.names == null) {
                this.names = new HashSet<String>();
                for (Node<U> child : this.children.values()) {
                    this.names.add(child.getFullName());
                }
            }
            return this.names;
        }

        public Collection<Node<U>> getChildren() {
            return this.children != null ? this.children.values() : Collections.emptySet();
        }
    }
}

