/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.structure.structurebuilder;

import java.util.List;
import java.util.Map;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.DeploymentFactory;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.spi.structure.StructureMetaDataFactory;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.test.BaseTestCase;

public abstract class AbstractStructureBuilderTest
extends BaseTestCase {
    public AbstractStructureBuilderTest(String name) {
        super(name);
    }

    protected abstract DeploymentContext build(Deployment var1) throws DeploymentException;

    protected abstract Deployment createDeployment();

    protected abstract DeploymentFactory getDeploymentFactory();

    protected abstract String getDeploymentName();

    protected Deployment createDeployment(DeploymentFactory factory) {
        Deployment deployment = this.createDeployment();
        factory.addContext((PredeterminedManagedObjectAttachments)deployment, "");
        return deployment;
    }

    public void testSimple() throws Exception {
        Deployment deployment = this.createSimple();
        DeploymentContext context = this.build(deployment);
        this.checkDeployment(context, deployment);
    }

    protected Deployment createSimple() throws Exception {
        Deployment deployment = this.createDeployment();
        StructureMetaData structure = StructureMetaDataFactory.createStructureMetaData();
        MutableAttachments attachments = (MutableAttachments)deployment.getPredeterminedManagedObjects();
        attachments.addAttachment(StructureMetaData.class, (Object)structure);
        DeploymentFactory factory = this.getDeploymentFactory();
        factory.addContext((PredeterminedManagedObjectAttachments)deployment, "");
        return deployment;
    }

    public void testSimpleWithAttachment() throws Exception {
        Deployment deployment = this.createSimpleWithAttachment();
        DeploymentContext context = this.build(deployment);
        this.checkDeployment(context, deployment);
    }

    protected Deployment createSimpleWithAttachment() throws Exception {
        Deployment deployment = this.createDeployment();
        StructureMetaData structure = StructureMetaDataFactory.createStructureMetaData();
        MutableAttachments attachments = (MutableAttachments)deployment.getPredeterminedManagedObjects();
        attachments.addAttachment(StructureMetaData.class, (Object)structure);
        attachments.addAttachment("test", (Object)"hello");
        DeploymentFactory factory = this.getDeploymentFactory();
        factory.addContext((PredeterminedManagedObjectAttachments)deployment, "");
        return deployment;
    }

    public void testOneChild() throws Exception {
        Deployment deployment = this.createOneChild();
        DeploymentContext context = this.build(deployment);
        this.checkDeployment(context, deployment);
    }

    protected Deployment createOneChild() throws Exception {
        DeploymentFactory factory = this.getDeploymentFactory();
        Deployment deployment = this.createDeployment(factory);
        factory.addContext((PredeterminedManagedObjectAttachments)deployment, "child1");
        return deployment;
    }

    public void testManyChildren() throws Exception {
        Deployment deployment = this.createManyChildren();
        DeploymentContext context = this.build(deployment);
        this.checkDeployment(context, deployment);
    }

    protected Deployment createManyChildren() throws Exception {
        DeploymentFactory factory = this.getDeploymentFactory();
        Deployment deployment = this.createDeployment(factory);
        factory.addContext((PredeterminedManagedObjectAttachments)deployment, "child1");
        factory.addContext((PredeterminedManagedObjectAttachments)deployment, "child2");
        factory.addContext((PredeterminedManagedObjectAttachments)deployment, "child3");
        return deployment;
    }

    public void testMetaDataLocation() throws Exception {
        Deployment deployment = this.createMetaDataLocation();
        DeploymentContext context = this.build(deployment);
        this.checkDeployment(context, deployment);
    }

    protected Deployment createMetaDataLocation() throws Exception {
        DeploymentFactory factory = this.getDeploymentFactory();
        Deployment deployment = this.createDeployment();
        factory.addContext((PredeterminedManagedObjectAttachments)deployment, "", "META-INF", DeploymentFactory.createClassPath((String)""));
        return deployment;
    }

    public void testClasspathEntries() throws Exception {
        Deployment deployment = this.createClasspathEntries();
        DeploymentContext context = this.build(deployment);
        this.checkDeployment(context, deployment);
    }

    protected Deployment createClasspathEntries() throws Exception {
        DeploymentFactory factory = this.getDeploymentFactory();
        Deployment deployment = this.createDeployment();
        ContextInfo contextInfo = factory.addContext((PredeterminedManagedObjectAttachments)deployment, "");
        contextInfo.addClassPathEntry(DeploymentFactory.createClassPathEntry((String)"cp1.txt"));
        contextInfo.addClassPathEntry(DeploymentFactory.createClassPathEntry((String)"cp2.txt"));
        return deployment;
    }

    protected void checkDeployment(DeploymentContext context, Deployment deployment) throws Exception {
        AbstractStructureBuilderTest.assertNotNull((Object)context);
        AbstractStructureBuilderTest.assertEquals((String)deployment.getName(), (String)context.getName());
        MutableAttachments attachments = (MutableAttachments)deployment.getPredeterminedManagedObjects();
        StructureMetaData structure = (StructureMetaData)attachments.getAttachment(StructureMetaData.class);
        this.checkAttachments(context, (PredeterminedManagedObjectAttachments)deployment);
        AbstractStructureBuilderTest.assertNotNull((Object)structure);
        this.checkDeployment(context, structure);
        ContextInfo contextInfo = structure.getContext("");
        AbstractStructureBuilderTest.assertNotNull((Object)contextInfo);
        this.checkContextInfo(context, contextInfo);
    }

    protected void checkDeployment(String parentName, DeploymentContext context, ContextInfo contextInfo) throws Exception {
        AbstractStructureBuilderTest.assertNotNull((Object)context);
        String expectedName = parentName.endsWith("/") ? parentName + contextInfo.getPath() : parentName + "/" + contextInfo.getPath();
        AbstractStructureBuilderTest.assertEquals((String)expectedName, (String)context.getName());
        StructureMetaData structure = (StructureMetaData)contextInfo.getPredeterminedManagedObjects().getAttachment(StructureMetaData.class);
        this.checkAttachments(context, (PredeterminedManagedObjectAttachments)contextInfo);
        if (structure != null) {
            this.checkDeployment(context, structure);
        }
        this.checkContextInfo(context, contextInfo);
    }

    protected void checkDeployment(DeploymentContext context, StructureMetaData structure) throws Exception {
        AbstractStructureBuilderTest.assertNotNull((Object)context);
        AbstractStructureBuilderTest.assertNotNull((Object)structure);
        List contextInfos = structure.getContexts();
        int numContexts = contextInfos.size();
        if (structure.getContext("") != null) {
            --numContexts;
        }
        List children = context.getChildren();
        int numChildren = children.size();
        AbstractStructureBuilderTest.assertEquals((String)("Should have the same number contexts=" + contextInfos + " children=" + children), (int)numContexts, (int)numChildren);
        for (DeploymentContext childContext : children) {
            ContextInfo contextInfo = structure.getContext(childContext.getRelativePath());
            AbstractStructureBuilderTest.assertNotNull((String)("Should have a context info " + childContext + " in " + contextInfos), (Object)contextInfo);
            this.checkDeployment(context.getName(), childContext, contextInfo);
        }
    }

    protected void checkAttachments(DeploymentContext context, PredeterminedManagedObjectAttachments predetermined) throws Exception {
        Map expected = predetermined.getPredeterminedManagedObjects().getAttachments();
        Map actual = context.getPredeterminedManagedObjects().getAttachments();
        AbstractStructureBuilderTest.assertEquals((Object)expected, (Object)actual);
    }

    protected void checkContextInfo(DeploymentContext context, ContextInfo contextInfo) throws Exception {
    }
}

