/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.structure.spi.helpers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.attachments.helpers.AbstractMutableAttachments;
import org.jboss.deployers.spi.deployer.DeploymentStage;
import org.jboss.deployers.structure.spi.ClassLoaderFactory;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentResourceLoader;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.DeploymentUnitVisitor;
import org.jboss.deployers.structure.spi.helpers.ComponentDeploymentContext;
import org.jboss.deployers.structure.spi.helpers.UnitVisitorToContextVisitor;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.MutableMetaData;
import org.jboss.metadata.spi.scope.ScopeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDeploymentUnit
extends AbstractMutableAttachments
implements DeploymentUnit {
    private static final long serialVersionUID = 1513962148798298768L;
    private DeploymentContext deploymentContext;

    public AbstractDeploymentUnit() {
    }

    public AbstractDeploymentUnit(DeploymentContext deploymentContext) {
        if (deploymentContext == null) {
            throw new IllegalArgumentException("Null deployment context");
        }
        this.deploymentContext = deploymentContext;
    }

    @Override
    public String getName() {
        return this.deploymentContext.getName();
    }

    @Override
    public Set<Object> getControllerContextNames() {
        return this.deploymentContext.getControllerContextNames();
    }

    @Override
    public void addControllerContextName(Object name) {
        this.deploymentContext.addControllerContextName(name);
    }

    @Override
    public void removeControllerContextName(Object name) {
        this.deploymentContext.removeControllerContextName(name);
    }

    @Override
    public String getSimpleName() {
        return this.deploymentContext.getSimpleName();
    }

    @Override
    public String getRelativePath() {
        return this.deploymentContext.getRelativePath();
    }

    @Override
    public ScopeKey getScope() {
        return this.deploymentContext.getScope();
    }

    @Override
    public void setScope(ScopeKey key) {
        this.deploymentContext.setScope(key);
    }

    @Override
    public ScopeKey getMutableScope() {
        return this.deploymentContext.getMutableScope();
    }

    @Override
    public void setMutableScope(ScopeKey key) {
        this.deploymentContext.setMutableScope(key);
    }

    @Override
    public MetaData getMetaData() {
        return this.deploymentContext.getMetaData();
    }

    @Override
    public MutableMetaData getMutableMetaData() {
        return this.deploymentContext.getMutableMetaData();
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader cl = this.deploymentContext.getClassLoader();
        if (cl == null) {
            throw new IllegalStateException("ClassLoader has not been set");
        }
        this.deploymentContext.deployed();
        return cl;
    }

    @Override
    public boolean createClassLoader(ClassLoaderFactory factory) throws DeploymentException {
        return this.deploymentContext.createClassLoader(factory);
    }

    @Override
    public void removeClassLoader(ClassLoaderFactory factory) {
        this.deploymentContext.removeClassLoader(factory);
    }

    @Override
    public boolean isTopLevel() {
        return this.deploymentContext.isTopLevel();
    }

    @Override
    public DeploymentUnit getTopLevel() {
        DeploymentContext context = this.deploymentContext.getTopLevel();
        return context.getDeploymentUnit();
    }

    @Override
    public DeploymentUnit getParent() {
        DeploymentContext parent = this.deploymentContext.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getDeploymentUnit();
    }

    @Override
    public List<DeploymentUnit> getChildren() {
        List<DeploymentContext> children = this.deploymentContext.getChildren();
        if (children == null || children.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DeploymentUnit> result = new ArrayList<DeploymentUnit>(children.size());
        for (DeploymentContext child : children) {
            DeploymentUnit unit = child.getDeploymentUnit();
            result.add(unit);
        }
        return result;
    }

    @Override
    public List<DeploymentUnit> getComponents() {
        List<DeploymentContext> components = this.deploymentContext.getComponents();
        if (components == null || components.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DeploymentUnit> result = new ArrayList<DeploymentUnit>(components.size());
        for (DeploymentContext component : components) {
            DeploymentUnit unit = component.getDeploymentUnit();
            result.add(unit);
        }
        return result;
    }

    protected DeploymentContext createComponentDeploymentContext(String name, DeploymentContext parent) {
        return new ComponentDeploymentContext(name, parent);
    }

    protected DeploymentUnit createComponentDeploymentUnit(DeploymentContext component) {
        return new AbstractDeploymentUnit(component);
    }

    @Override
    public boolean isComponent() {
        return this.deploymentContext.isComponent();
    }

    @Override
    public DeploymentUnit addComponent(String name) {
        DeploymentContext component = this.createComponentDeploymentContext(name, this.deploymentContext);
        DeploymentUnit unit = this.createComponentDeploymentUnit(component);
        component.setDeploymentUnit(unit);
        this.deploymentContext.addComponent(component);
        return unit;
    }

    protected DeploymentContext getComponentContext(String name) {
        List<DeploymentContext> components = this.deploymentContext.getComponents();
        if (components == null || components.isEmpty()) {
            return null;
        }
        for (DeploymentContext component : components) {
            if (!name.equals(component.getName())) continue;
            return component;
        }
        return null;
    }

    @Override
    public DeploymentUnit getComponent(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        DeploymentContext component = this.getComponentContext(name);
        return component != null ? component.getDeploymentUnit() : null;
    }

    @Override
    public boolean removeComponent(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        DeploymentContext component = this.getComponentContext(name);
        return component != null && this.deploymentContext.removeComponent(component);
    }

    @Override
    public <T> Set<? extends T> getAllMetaData(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        HashSet<T> result = new HashSet<T>();
        Map<String, Object> attachments = this.getAttachments();
        for (Object object : attachments.values()) {
            if (!type.isInstance(object)) continue;
            T t = type.cast(object);
            result.add(t);
        }
        if (!result.isEmpty()) {
            this.deploymentContext.deployed();
        }
        return result;
    }

    @Override
    public MutableAttachments getTransientManagedObjects() {
        return this.getDeploymentContext().getTransientManagedObjects();
    }

    public Object addAttachment(String name, Object attachment) {
        DeploymentContext deploymentContext = this.getDeploymentContext();
        deploymentContext.deployed();
        return deploymentContext.getTransientAttachments().addAttachment(name, attachment);
    }

    public void clear() {
        DeploymentContext deploymentContext = this.getDeploymentContext();
        deploymentContext.getTransientAttachments().clear();
        deploymentContext.getTransientManagedObjects().clear();
    }

    public void clearChangeCount() {
        DeploymentContext deploymentContext = this.getDeploymentContext();
        deploymentContext.getTransientAttachments().clearChangeCount();
        deploymentContext.getTransientManagedObjects().clearChangeCount();
    }

    public int getChangeCount() {
        DeploymentContext deploymentContext = this.getDeploymentContext();
        return deploymentContext.getTransientAttachments().getChangeCount() + deploymentContext.getTransientManagedObjects().getChangeCount();
    }

    public Object removeAttachment(String name) {
        return this.getDeploymentContext().getTransientAttachments().removeAttachment(name);
    }

    public Object getAttachment(String name) {
        Object result;
        DeploymentContext deploymentContext = this.getDeploymentContext();
        DeploymentContext parent = deploymentContext.getParent();
        if (!deploymentContext.isComponent()) {
            parent = null;
        }
        if ((result = deploymentContext.getPredeterminedManagedObjects().getAttachment(name)) != null) {
            deploymentContext.deployed();
            return result;
        }
        if (parent != null && (result = parent.getPredeterminedManagedObjects().getAttachment(name)) != null) {
            deploymentContext.deployed();
            return result;
        }
        result = deploymentContext.getTransientManagedObjects().getAttachment(name);
        if (result != null) {
            deploymentContext.deployed();
            return result;
        }
        if (parent != null && (result = parent.getTransientManagedObjects().getAttachment(name)) != null) {
            deploymentContext.deployed();
            return result;
        }
        result = deploymentContext.getTransientAttachments().getAttachment(name);
        if (result != null) {
            deploymentContext.deployed();
            return result;
        }
        if (parent != null && (result = parent.getTransientAttachments().getAttachment(name)) != null) {
            deploymentContext.deployed();
            return result;
        }
        return null;
    }

    public Map<String, Object> getAttachments() {
        DeploymentContext deploymentContext = this.getDeploymentContext();
        DeploymentContext parent = deploymentContext.getParent();
        if (!deploymentContext.isComponent()) {
            parent = null;
        }
        HashMap result = new HashMap();
        if (parent != null) {
            result.putAll(parent.getTransientAttachments().getAttachments());
        }
        result.putAll(deploymentContext.getTransientAttachments().getAttachments());
        if (parent != null) {
            result.putAll(parent.getTransientManagedObjects().getAttachments());
        }
        result.putAll(deploymentContext.getTransientManagedObjects().getAttachments());
        if (parent != null) {
            result.putAll(parent.getPredeterminedManagedObjects().getAttachments());
        }
        result.putAll(deploymentContext.getPredeterminedManagedObjects().getAttachments());
        if (!result.isEmpty()) {
            deploymentContext.deployed();
        }
        return Collections.unmodifiableMap(result);
    }

    public boolean hasAttachments() {
        DeploymentContext deploymentContext = this.getDeploymentContext();
        if (deploymentContext.getTransientAttachments().hasAttachments()) {
            return true;
        }
        if (deploymentContext.getTransientManagedObjects().hasAttachments()) {
            return true;
        }
        if (deploymentContext.getPredeterminedManagedObjects().hasAttachments()) {
            return true;
        }
        if (deploymentContext.isComponent()) {
            return deploymentContext.getParent().getDeploymentUnit().hasAttachments();
        }
        return false;
    }

    public boolean isAttachmentPresent(String name) {
        return this.getAttachment(name) != null;
    }

    @Override
    public ClassLoader getResourceClassLoader() {
        return this.getDeploymentContext().getResourceClassLoader();
    }

    @Override
    public DeploymentResourceLoader getResourceLoader() {
        return this.getDeploymentContext().getResourceLoader();
    }

    @Override
    public void addIDependOn(DependencyItem dependency) {
        this.getDependencyInfo().addIDependOn(dependency);
    }

    @Override
    public void visit(DeploymentUnitVisitor visitor) throws DeploymentException {
        UnitVisitorToContextVisitor contextVisitor = new UnitVisitorToContextVisitor(visitor);
        this.getDeploymentContext().visit(contextVisitor);
    }

    @Override
    public Object getControllerContextName() {
        return this.getDeploymentContext().getControllerContextName();
    }

    @Override
    public DeploymentStage getRequiredStage() {
        return this.getDeploymentContext().getRequiredStage();
    }

    @Override
    public void setRequiredStage(DeploymentStage stage) {
        this.getDeploymentContext().setRequiredStage(stage);
    }

    @Override
    public DependencyInfo getDependencyInfo() {
        return this.getDeploymentContext().getDependencyInfo();
    }

    @Override
    public void removeIDependOn(DependencyItem dependency) {
        this.getDependencyInfo().removeIDependOn(dependency);
    }

    @Override
    public MainDeployer getMainDeployer() {
        return (MainDeployer)this.getTopLevel().getAttachment(MainDeployer.class);
    }

    protected DeploymentContext getDeploymentContext() {
        return this.deploymentContext;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.deploymentContext = (DeploymentContext)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.deploymentContext);
    }

    public String toString() {
        return String.valueOf(this.deploymentContext);
    }
}

