/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.structure.attachments.test;

import java.util.Date;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.spi.attachments.LocalAttachments;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.helpers.AbstractDeploymentContext;
import org.jboss.deployers.structure.spi.helpers.AbstractDeploymentUnit;
import org.jboss.test.deployers.attachments.test.AttachmentsTest;
import org.jboss.test.deployers.attachments.test.ExpectedAttachments;

public class AbstractLocalAttachmentsUnitTestCase
extends AttachmentsTest {
    private DeploymentUnit unit;

    public static Test suite() {
        return new TestSuite(AbstractLocalAttachmentsUnitTestCase.class);
    }

    public AbstractLocalAttachmentsUnitTestCase(String name) {
        super(name);
        AbstractDeploymentContext context = new AbstractDeploymentContext("attachments", "");
        this.unit = new AbstractDeploymentUnit((DeploymentContext)context);
        context.setDeploymentUnit(this.unit);
    }

    public void testLocal() throws Exception {
        DeploymentUnit component = this.unit.addComponent("component");
        Date date1 = new Date();
        Date date2 = new Date();
        Integer i1 = 1;
        this.unit.addAttachment(Date.class, (Object)date1);
        this.unit.addAttachment("date1", (Object)date1, Date.class);
        component.addAttachment(Date.class, (Object)date2);
        component.addAttachment("date2", (Object)date2, Date.class);
        this.unit.addAttachment(Integer.class, (Object)i1);
        ExpectedAttachments ea = new ExpectedAttachments();
        ea.add("date2", (Object)date2);
        ea.add(Date.class.getName(), (Object)date2);
        AbstractLocalAttachmentsUnitTestCase.assertEquals((Object)i1, (Object)this.unit.getAttachment(Integer.class));
        AbstractLocalAttachmentsUnitTestCase.assertEquals((Object)i1, (Object)component.getAttachment(Integer.class));
        LocalAttachments la = (LocalAttachments)this.assertInstanceOf(component, LocalAttachments.class);
        AbstractLocalAttachmentsUnitTestCase.assertEquals((Object)date2, (Object)la.getLocalAttachment(Date.class));
        AbstractLocalAttachmentsUnitTestCase.assertEquals((Object)date2, (Object)la.getLocalAttachment("date2"));
        AbstractLocalAttachmentsUnitTestCase.assertEquals((Object)date2, (Object)la.getLocalAttachment("date2", Date.class));
        AbstractLocalAttachmentsUnitTestCase.assertTrue((boolean)la.isLocalAttachmentPresent(Date.class));
        AbstractLocalAttachmentsUnitTestCase.assertTrue((boolean)la.isLocalAttachmentPresent("date2"));
        AbstractLocalAttachmentsUnitTestCase.assertTrue((boolean)la.isLocalAttachmentPresent("date2", Date.class));
        AbstractLocalAttachmentsUnitTestCase.assertTrue((boolean)la.hasLocalAttachments());
        AbstractLocalAttachmentsUnitTestCase.assertEquals((Object)ea.expected, (Object)la.getLocalAttachments());
    }

    public void testSerialization() throws Exception {
    }

    protected Attachments getAttachments() {
        return this.unit;
    }

    protected MutableAttachments getMutable() {
        return this.unit;
    }
}

