/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.deployer;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSParsingDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.virtual.VirtualFile;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JAXPDeployer<T>
extends AbstractVFSParsingDeployer<T> {
    private boolean useNamespaceAwareParser = true;
    private boolean validateDTDs;
    private DocumentBuilderFactory documentBuilderFactory;

    public JAXPDeployer(Class<T> output) {
        super(output);
    }

    public boolean isUseNamespaceAwareParser() {
        return this.useNamespaceAwareParser;
    }

    public void setUseNamespaceAwareParser(boolean useNamespaceAwareParser) {
        this.useNamespaceAwareParser = useNamespaceAwareParser;
    }

    public boolean isValidateDTDs() {
        return this.validateDTDs;
    }

    public void setValidateDTDs(boolean validateDTDs) {
        this.validateDTDs = validateDTDs;
    }

    protected DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.documentBuilderFactory == null) {
            throw new IllegalStateException("Document builder factory has not been constructed");
        }
        return this.documentBuilderFactory;
    }

    public void create() throws Exception {
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(this.useNamespaceAwareParser);
        this.documentBuilderFactory.setValidating(this.validateDTDs);
    }

    public void destroy() {
        this.documentBuilderFactory = null;
    }

    @Override
    protected T parse(VFSDeploymentUnit unit, VirtualFile file, T root) throws Exception {
        Document document = (Document)unit.getAttachment(Document.class);
        if (document == null) {
            document = this.doParse(unit, file);
        }
        return this.parse(unit, file, document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document doParse(VFSDeploymentUnit unit, VirtualFile file) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        this.log.trace((Object)("Parsing: " + file.getName()));
        InputStream is = this.openStreamAndValidate(file);
        try {
            DocumentBuilder parser = this.getDocumentBuilderFactory().newDocumentBuilder();
            InputSource source = new InputSource(is);
            source.setSystemId(file.toURI().toString());
            parser.setEntityResolver((EntityResolver)new JBossEntityResolver());
            Document document = parser.parse(is);
            return document;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception ignored) {}
        }
    }

    @Override
    protected abstract T parse(VFSDeploymentUnit var1, VirtualFile var2, Document var3) throws Exception;
}

