/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.deployer;

import java.io.InputStream;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSParsingDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.virtual.VirtualFile;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaResolverDeployer<T>
extends AbstractVFSParsingDeployer<T> {
    private static final UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
    private static final SchemaBindingResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
    private boolean useSchemaValidation = true;
    private boolean useValidation = true;

    public SchemaResolverDeployer(Class<T> output) {
        super(output);
    }

    public boolean isUseSchemaValidation() {
        return this.useSchemaValidation;
    }

    public void setUseSchemaValidation(boolean useSchemaValidation) {
        this.useSchemaValidation = useSchemaValidation;
    }

    public boolean isUseValidation() {
        return this.useValidation;
    }

    public void setUseValidation(boolean useValidation) {
        this.useValidation = useValidation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T parse(VFSDeploymentUnit unit, VirtualFile file, T root) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        this.log.debug((Object)("Parsing file: " + file + " for deploymentType: " + this.getOutput()));
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        unmarshaller.setSchemaValidation(this.isUseSchemaValidation());
        unmarshaller.setValidation(this.isUseValidation());
        InputStream is = this.openStreamAndValidate(file);
        Object parsed = null;
        try {
            parsed = unmarshaller.unmarshal(is, resolver);
            this.log.debug((Object)("Parsed file: " + file + " to: " + parsed));
        }
        finally {
            try {
                is.close();
            }
            catch (Exception ignored) {}
        }
        if (parsed == null) {
            throw new DeploymentException("The xml " + file.getPathName() + " is not well formed!");
        }
        return this.getOutput().cast(parsed);
    }
}

