/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.deployer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.vfs.spi.deployer.MultipleSchemaResolverDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JBossExtensionDeployer<U, V, T>
extends MultipleSchemaResolverDeployer<T> {
    private String specName;
    private Class<U> specClass;
    private String jbossName;
    private Class<V> jbossClass;

    public JBossExtensionDeployer(Class<T> output, String specName, Class<U> specClass, String jbossName, Class<V> jbossClass) {
        this(output, specName, specClass, jbossName, jbossClass, null);
    }

    public JBossExtensionDeployer(Class<T> output, String specName, Class<U> specClass, String jbossName, Class<V> jbossClass, Set<Class<?>> excluded) {
        super(output, JBossExtensionDeployer.toMap(specName, specClass, jbossName, jbossClass), excluded);
        if (specClass == null) {
            throw new IllegalArgumentException("Null spec class");
        }
        if (jbossClass == null) {
            throw new IllegalArgumentException("Null jboss class");
        }
        this.specName = specName;
        this.specClass = specClass;
        this.jbossName = jbossName;
        this.jbossClass = jbossClass;
    }

    protected static Map<String, Class<?>> toMap(String specName, Class specClass, String jbossName, Class jbossClass) {
        HashMap map = new HashMap();
        map.put(specName, specClass);
        map.put(jbossName, jbossClass);
        return map;
    }

    @Override
    protected T mergeMetaData(VFSDeploymentUnit unit, T root, Map<Class<?>, List<Object>> metadata, Set<String> missingFiles) throws Exception {
        if (this.specClass.equals(this.jbossClass)) {
            List<Object> instances = metadata.get(this.specClass);
            if (instances == null || instances.isEmpty()) {
                return this.mergeMetaData(unit, null, null);
            }
            if (instances.size() == 1) {
                if (missingFiles.contains(this.jbossName)) {
                    return this.mergeMetaData(unit, this.specClass.cast(instances.iterator().next()), null);
                }
                if (missingFiles.contains(this.specName)) {
                    return this.mergeMetaData(unit, null, this.jbossClass.cast(instances.iterator().next()));
                }
                throw new IllegalArgumentException("Should be either missing spec or jboss: " + missingFiles);
            }
            return this.mergeMetaData(unit, this.specClass.cast(instances.get(0)), this.jbossClass.cast(instances.get(1)));
        }
        return super.mergeMetaData(unit, root, metadata, missingFiles);
    }

    @Override
    protected T mergeMetaData(VFSDeploymentUnit unit, Map<Class<?>, List<Object>> metadata) throws Exception {
        return this.mergeMetaData(unit, this.getInstance(metadata, this.specClass), this.getInstance(metadata, this.jbossClass));
    }

    protected abstract T mergeMetaData(VFSDeploymentUnit var1, U var2, V var3) throws Exception;
}

