/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.modified;

import java.io.IOException;
import java.net.URISyntaxException;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.main.MainDeployerInternals;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
import org.jboss.deployers.vfs.spi.structure.modified.DefaultStructureCache;
import org.jboss.deployers.vfs.spi.structure.modified.ModificationCheckerFilter;
import org.jboss.deployers.vfs.spi.structure.modified.StructureCache;
import org.jboss.deployers.vfs.spi.structure.modified.StructureModificationChecker;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStructureModificationChecker<T>
implements StructureModificationChecker {
    protected Logger log = Logger.getLogger(this.getClass());
    private MainDeployerInternals mainDeployer;
    private ModificationCheckerFilter rootFilter;
    private volatile StructureCache<T> cache;

    protected AbstractStructureModificationChecker() {
    }

    protected AbstractStructureModificationChecker(MainDeployerInternals mainDeployer) {
        if (mainDeployer == null) {
            throw new IllegalArgumentException("Null main deployer");
        }
        this.mainDeployer = mainDeployer;
    }

    protected ModificationCheckerFilter getRootFilter() {
        if (this.rootFilter == null) {
            this.rootFilter = new DefaultRootFilter();
        }
        return this.rootFilter;
    }

    public void setRootFilter(ModificationCheckerFilter rootFilter) {
        if (rootFilter == null) {
            throw new IllegalArgumentException("Null root filter");
        }
        this.rootFilter = rootFilter;
    }

    protected StructureCache<T> getCache() {
        if (this.cache == null) {
            this.cache = new DefaultStructureCache();
        }
        return this.cache;
    }

    public void setCache(StructureCache<T> cache) {
        this.cache = cache;
    }

    protected MainDeployerInternals getMainDeployerInternals() {
        if (this.mainDeployer == null) {
            throw new IllegalArgumentException("Null main deployer structure");
        }
        return this.mainDeployer;
    }

    protected VFSDeploymentContext getDeploymentContext(String name) {
        DeploymentContext deploymentContext = this.getMainDeployerInternals().getDeploymentContext(name);
        if (deploymentContext == null || !(deploymentContext instanceof VFSDeploymentContext)) {
            return null;
        }
        return (VFSDeploymentContext)deploymentContext;
    }

    @Override
    public boolean hasStructureBeenModified(VirtualFile root) throws IOException {
        boolean result;
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        if (this.getRootFilter().accepts(root) && ((result = this.hasRootBeenModified(root)) || this.getRootFilter().checkRootOnly(root))) {
            if (result) {
                this.getCache().invalidateCache(root);
            }
            return result;
        }
        try {
            String name = root.toURI().toString();
            VFSDeploymentContext deploymentContext = this.getDeploymentContext(name);
            if (deploymentContext != null) {
                return this.hasStructureBeenModified(deploymentContext, false);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.log.trace((Object)("Falling back to root name: " + root));
        VFSDeploymentContext deploymentContext = this.getDeploymentContext(root.getName());
        if (deploymentContext != null) {
            return this.hasStructureBeenModified(deploymentContext, false);
        }
        return false;
    }

    @Override
    public boolean hasStructureBeenModified(VFSDeployment deployment) throws IOException {
        if (deployment == null) {
            throw new IllegalArgumentException("Null deployment");
        }
        VFSDeploymentContext deploymentContext = this.getDeploymentContext(deployment.getName());
        return deploymentContext != null && this.hasStructureBeenModified(deploymentContext);
    }

    @Override
    public boolean hasStructureBeenModified(VFSDeploymentContext deploymentContext) throws IOException {
        return this.hasStructureBeenModified(deploymentContext, true);
    }

    protected boolean hasStructureBeenModified(VFSDeploymentContext deploymentContext, boolean checkRoot) throws IOException {
        Deployment deployment = deploymentContext.getDeployment();
        if (deployment == null || !(deployment instanceof VFSDeployment)) {
            this.log.warn((Object)"Deployment is not VFS or not top level.");
            return false;
        }
        VFSDeployment vfsDeployment = (VFSDeployment)VFSDeployment.class.cast(deployment);
        VirtualFile root = vfsDeployment.getRoot();
        boolean result = false;
        boolean skip = false;
        if (checkRoot && this.getRootFilter().accepts(root) && ((result = this.hasRootBeenModified(root)) || this.getRootFilter().checkRootOnly(root))) {
            skip = true;
        }
        if (!skip) {
            result = this.hasStructureBeenModifed(root, deploymentContext);
        }
        if (result) {
            this.getCache().invalidateCache(root);
        }
        return result;
    }

    protected boolean hasRootBeenModified(VirtualFile root) throws IOException {
        return root.hasBeenModified();
    }

    protected abstract boolean hasStructureBeenModifed(VirtualFile var1, VFSDeploymentContext var2) throws IOException;

    @Override
    public void addStructureRoot(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        this.getCache().initializeCache(root);
    }

    @Override
    public void removeStructureRoot(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        this.getCache().removeCache(root);
    }

    private static class DefaultRootFilter
    implements ModificationCheckerFilter {
        private DefaultRootFilter() {
        }

        public boolean accepts(VirtualFile file) {
            try {
                return file.isLeaf() || file.isArchive();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean checkRootOnly(VirtualFile root) {
            return true;
        }
    }
}

