/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.classloader;

import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloading.plugins.vfs.PackageVisitor;
import org.jboss.classloading.plugins.vfs.VFSResourceVisitor;
import org.jboss.classloading.spi.metadata.Capability;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaDataFactory;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.vfs.policy.VFSClassLoaderPolicy;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.plugins.classloading.AbstractDeploymentClassLoaderPolicyModule;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.DeploymentUnitVisitor;
import org.jboss.deployers.vfs.spi.structure.helpers.ClassPathVisitor;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSDeploymentClassLoaderPolicyModule
extends AbstractDeploymentClassLoaderPolicyModule {
    private static final long serialVersionUID = 1L;
    private VirtualFile[] vfsRoots;

    public VFSDeploymentClassLoaderPolicyModule(DeploymentUnit unit) {
        super(unit);
    }

    protected List<Capability> determineCapabilities() {
        VirtualFile[] roots = this.determineVFSRoots();
        CopyOnWriteArrayList<Capability> capabilities = super.determineCapabilities();
        if (capabilities != null) {
            return capabilities;
        }
        ClassLoadingMetaDataFactory factory = ClassLoadingMetaDataFactory.getInstance();
        capabilities = new CopyOnWriteArrayList<Capability>();
        Object version = this.getVersion();
        Capability capability = factory.createModule(this.getName(), version);
        capabilities.add(capability);
        ClassFilter included = this.getIncluded();
        ClassFilter excluded = this.getExcluded();
        ClassFilter excludedExport = this.getExcludedExport();
        ExportAll exportAll = this.getExportAll();
        if (exportAll != null) {
            Set exportedPackages = PackageVisitor.determineAllPackages((VirtualFile[])roots, (ExportAll)exportAll, (ClassFilter)included, (ClassFilter)excluded, (ClassFilter)excludedExport);
            for (String packageName : exportedPackages) {
                capability = factory.createPackage(packageName, version);
                capabilities.add(capability);
            }
        }
        return capabilities;
    }

    protected VirtualFile[] determineVFSRoots() {
        if (this.vfsRoots != null) {
            return this.vfsRoots;
        }
        ClassPathVisitor visitor = new ClassPathVisitor(this.getDeploymentUnit());
        try {
            this.getDeploymentUnit().visit((DeploymentUnitVisitor)visitor);
        }
        catch (DeploymentException e) {
            throw new RuntimeException("Error visiting deployment: " + (Object)((Object)e));
        }
        Set classPath = visitor.getClassPath();
        this.vfsRoots = classPath.toArray(new VirtualFile[classPath.size()]);
        return this.vfsRoots;
    }

    public VFSClassLoaderPolicy getPolicy() {
        return (VFSClassLoaderPolicy)super.getPolicy();
    }

    protected VFSClassLoaderPolicy determinePolicy() {
        VirtualFile[] roots = this.determineVFSRoots();
        VFSClassLoaderPolicy policy = VFSClassLoaderPolicy.createVFSClassLoaderPolicy((String)this.getContextName(), (VirtualFile[])roots);
        String[] packageNames = this.getPackageNames();
        policy.setExportedPackages(packageNames);
        policy.setIncluded(this.getIncluded());
        policy.setExcluded(this.getExcluded());
        policy.setExcludedExport(this.getExcludedExport());
        policy.setExportAll(this.getExportAll());
        policy.setImportAll(this.isImportAll());
        policy.setCacheable(this.isCacheable());
        policy.setBlackListable(this.isBlackListable());
        policy.setDelegates(this.getDelegates());
        return policy;
    }

    public URL getDynamicClassRoot() {
        return (URL)this.getDeploymentUnit().getAttachment("DYNAMIC_CLASS_URL_KEY", URL.class);
    }

    public void reset() {
        super.reset();
        this.vfsRoots = null;
    }

    public void visit(ResourceVisitor visitor, ResourceFilter filter) {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("ClassLoader has not been constructed for " + this.getContextName());
        }
        VirtualFile[] roots = this.determineVFSRoots();
        if (roots != null) {
            ClassFilter included = this.getIncluded();
            ClassFilter excluded = this.getExcluded();
            VFSResourceVisitor.visit((VirtualFile[])roots, (ClassFilter)included, (ClassFilter)excluded, (ClassLoader)classLoader, (ResourceVisitor)visitor, (ResourceFilter)filter);
        }
    }
}

