/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.classloader;

import java.net.URL;
import java.util.List;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.util.id.GUID;
import org.jboss.virtual.MemoryFileFactory;
import org.jboss.virtual.VirtualFile;

public class InMemoryClassesDeployer
extends AbstractVFSRealDeployer {
    public static final String DYNAMIC_CLASS_URL_KEY = "DYNAMIC_CLASS_URL_KEY";
    public static final String DYNAMIC_CLASS_KEY = "DYNAMIC_CLASS_KEY";

    public InMemoryClassesDeployer() {
        this.setStage(DeploymentStages.DESCRIBE);
        this.setOutput(ClassLoadingMetaData.class);
        this.setTopLevelOnly(true);
    }

    public void deploy(VFSDeploymentUnit unit) throws DeploymentException {
        try {
            URL dynamicClassRoot = new URL("vfsmemory", GUID.asString(), "");
            VirtualFile classes = MemoryFileFactory.createRoot((URL)dynamicClassRoot).getRoot();
            unit.addAttachment(DYNAMIC_CLASS_URL_KEY, (Object)dynamicClassRoot);
            unit.addAttachment(DYNAMIC_CLASS_KEY, (Object)classes);
            unit.prependClassPath(new VirtualFile[]{classes});
            this.log.debug((Object)("Dynamic class root for " + unit.getName() + " is " + dynamicClassRoot));
        }
        catch (Exception e) {
            throw new DeploymentException("Error creating dynamic class root", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(VFSDeploymentUnit unit) {
        this.log.debug((Object)("Removing dynamic class root for " + unit.getName()));
        try {
            List classPath;
            VirtualFile classes = (VirtualFile)unit.removeAttachment(DYNAMIC_CLASS_KEY, VirtualFile.class);
            if (classes != null && (classPath = unit.getClassPath()) != null) {
                classPath.remove(classes);
                unit.setClassPath(classPath);
            }
        }
        finally {
            try {
                URL root = (URL)unit.removeAttachment(DYNAMIC_CLASS_URL_KEY, URL.class);
                if (root != null) {
                    MemoryFileFactory.deleteRoot((URL)root);
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Error deleting dynamic class root for " + unit.getName()), (Throwable)e);
            }
        }
    }
}

