/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure.war;

import java.io.IOException;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSStructureDeployer;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.vfs.helpers.SuffixMatchFilter;

public class WARStructure
extends AbstractVFSStructureDeployer {
    public static final VirtualFileFilter DEFAULT_WEB_INF_LIB_FILTER = new SuffixMatchFilter(".jar", VisitorAttributes.DEFAULT);
    private VirtualFileFilter webInfLibFilter = DEFAULT_WEB_INF_LIB_FILTER;

    public WARStructure() {
        this.setRelativeOrder(1000);
    }

    public VirtualFileFilter getWebInfLibFilter() {
        return this.webInfLibFilter;
    }

    public void setWebInfLibFilter(VirtualFileFilter webInfLibFilter) {
        if (webInfLibFilter == null) {
            throw new IllegalArgumentException("Null filter");
        }
        this.webInfLibFilter = webInfLibFilter;
    }

    /*
     * Unable to fully structure code
     */
    public boolean determineStructure(StructureContext structureContext) throws DeploymentException {
        context = null;
        file = structureContext.getFile();
        try {
            trace = this.log.isTraceEnabled();
            if (!WARStructure.isLeaf((VirtualFile)file)) {
                if (!file.getName().endsWith(".war")) {
                    try {
                        child = file.getChild("WEB-INF");
                        if (child != null) {
                            if (!trace) ** GOTO lbl21
                            this.log.trace((Object)"... ok - directory has a WEB-INF subdirectory");
                        }
                        if (trace) {
                            this.log.trace((Object)"... no - doesn't look like a war and no WEB-INF subdirectory.");
                        }
                        return false;
                    }
                    catch (IOException e) {
                        this.log.warn((Object)("Exception while checking if file is a war: " + e));
                        return false;
                    }
                } else if (trace) {
                    this.log.trace((Object)"... ok - name ends in .war.");
                }
lbl21:
                // 5 sources

                context = this.createContext(structureContext, new String[]{"WEB-INF", "WEB-INF/classes/META-INF"});
                this.addClassPath(structureContext, file, false, true, context);
                try {
                    classes = file.getChild("WEB-INF/classes");
                    if (classes != null) {
                        this.addClassPath(structureContext, classes, true, false, context);
                    } else if (trace) {
                        this.log.trace((Object)("No WEB-INF/classes for: " + file.getPathName()));
                    }
                }
                catch (IOException e) {
                    this.log.warn((Object)("Exception while looking for classes, " + file.getPathName() + ", " + e));
                }
                try {
                    webinfLib = file.getChild("WEB-INF/lib");
                    if (webinfLib != null) {
                        archives = webinfLib.getChildren(this.webInfLibFilter);
                        for (VirtualFile jar : archives) {
                            this.addClassPath(structureContext, jar, true, true, context);
                        }
                    } else if (trace) {
                        this.log.trace((Object)("No WEB-INF/lib for: " + file.getPathName()));
                    }
                }
                catch (IOException e) {
                    this.log.warn((Object)("Exception looking for WEB-INF/lib, " + file.getPathName() + ", " + e));
                }
                return true;
            }
            if (trace) {
                this.log.trace((Object)"... no - not a directory or an archive.");
            }
            return false;
        }
        catch (Exception e) {
            if (context != null) {
                structureContext.removeChild(context);
            }
            throw DeploymentException.rethrowAsDeploymentException((String)("Error determining structure: " + file.getName()), (Throwable)e);
        }
    }
}

