/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure.jar;

import java.io.IOException;
import java.util.Set;
import org.jboss.beans.metadata.api.annotations.Install;
import org.jboss.beans.metadata.api.annotations.Uninstall;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.matchers.JarExtensionProvider;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSStructureDeployer;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.context.jar.JarUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JARStructure
extends AbstractVFSStructureDeployer {
    public JARStructure() {
        this(null);
    }

    public JARStructure(Set<String> suffixes) {
        if (suffixes != null) {
            this.setSuffixes(suffixes);
        }
        this.setRelativeOrder(10000);
    }

    public Set<String> getSuffixes() {
        return JarUtils.getSuffixes();
    }

    public void setSuffixes(Set<String> suffixes) {
        JarUtils.setJarSuffixes(suffixes);
    }

    @Install
    public void addJarExtension(JarExtensionProvider provider) {
        String extension = provider.getJarExtension();
        if (extension != null) {
            JarUtils.addJarSuffix((String)extension);
        }
    }

    @Uninstall
    public void removeJarExtension(JarExtensionProvider provider) {
        String extension = provider.getJarExtension();
        if (extension != null) {
            JarUtils.removeJarSuffix((String)extension);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean determineStructure(StructureContext structureContext) throws DeploymentException {
        ContextInfo context = null;
        VirtualFile file = structureContext.getFile();
        try {
            StructureContext parentContext;
            boolean trace;
            block19: {
                block20: {
                    trace = this.log.isTraceEnabled();
                    if (JARStructure.isLeaf((VirtualFile)file)) break block20;
                    if (!JarUtils.isArchive((String)file.getName())) {
                        if (!structureContext.isTopLevel()) {
                            try {
                                VirtualFile child = file.getChild("META-INF");
                                if (child != null) {
                                    if (trace) {
                                        this.log.trace((Object)"... ok - non top level directory has a META-INF subdirectory");
                                    }
                                    break block19;
                                }
                                if (trace) {
                                    this.log.trace((Object)"... no - doesn't look like a jar and no META-INF subdirectory.");
                                }
                                return false;
                            }
                            catch (IOException e) {
                                this.log.warn((Object)("Exception while checking if file is a jar: " + e));
                                return false;
                            }
                        }
                        if (trace) {
                            this.log.trace((Object)"... ok - doesn't look like a jar but it is a top level directory.");
                        }
                        break block19;
                    } else {
                        this.log.trace((Object)"... ok - its an archive or at least pretending to be");
                    }
                    break block19;
                }
                if (JarUtils.isArchive((String)file.getName())) {
                    if (trace) {
                        this.log.trace((Object)"... ok - its an archive or at least pretending to be.");
                    }
                } else {
                    if (trace) {
                        this.log.trace((Object)"... no - not a directory or an archive.");
                    }
                    return false;
                }
            }
            boolean valid = true;
            if (this.isSupportsCandidateAnnotations() && (parentContext = structureContext.getParentContext()) != null && parentContext.isCandidateAnnotationScanning()) {
                valid = this.checkCandidateAnnotations(structureContext, new VirtualFile[]{file});
                if (trace) {
                    this.log.trace((Object)("... candidate annotations for " + file + " returned " + valid));
                }
            }
            if (valid) {
                context = this.createContext(structureContext, "META-INF");
                this.addClassPath(structureContext, file, true, true, context);
                this.addAllChildren(structureContext);
            }
            return valid;
        }
        catch (Exception e) {
            if (context != null) {
                structureContext.removeChild(context);
            }
            throw DeploymentException.rethrowAsDeploymentException((String)("Error determining structure: " + file.getName()), (Throwable)e);
        }
    }
}

