/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.developer.stacks.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.jboss.developer.stacks.client.StacksClientConfiguration;

public class DefaultStacksClientConfiguration
implements StacksClientConfiguration {
    private URL url;
    private String proxyHost;
    private int proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private boolean online = true;
    private int cacheRefreshPeriodSeconds = 86400;

    @Override
    public URL getUrl() {
        String repo = null;
        if (this.url == null) {
            try {
                repo = System.getProperty("jboss-developer.stacks.client.repo");
                if (repo == null) {
                    repo = this.getPropertyFromConfig();
                }
                return new URL(repo);
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Could not create URL from '%s'", repo));
            }
        }
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPropertyFromConfig() throws IOException {
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("/org/jboss/developer/stacks/client/config.properties");
            Properties p = new Properties();
            p.load(is);
            String string = p.getProperty("jboss-developer.stacks.client.repo");
            return string;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    public int getProxyPort() {
        return this.proxyPort;
    }

    @Override
    public String getProxyUser() {
        return this.proxyUser;
    }

    @Override
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Override
    public void setUrl(URL url) {
        this.url = url;
    }

    @Override
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Override
    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Override
    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    @Override
    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    @Override
    public boolean isOnline() {
        return this.online;
    }

    @Override
    public void setOnline(boolean online) {
        this.online = online;
    }

    @Override
    public int getCacheRefreshPeriodInSeconds() {
        return this.cacheRefreshPeriodSeconds;
    }

    @Override
    public void setCacheRefreshPeriodInSeconds(int seconds) {
        this.cacheRefreshPeriodSeconds = seconds;
    }
}

