/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.async.impl.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.logging.Logger;

public class ResultUnwrappingFuture<V>
extends FutureTask<V>
implements Future<V> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ResultUnwrappingFuture.class);

    public ResultUnwrappingFuture(Callable<V> callable) {
        super(callable);
    }

    public ResultUnwrappingFuture(Runnable runnable, V result) {
        super(runnable, result);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Blocking request to get()");
        }
        Object returnValueFromBeanProvider = super.get();
        V wrappedValue = this.getWrappedFuture(returnValueFromBeanProvider);
        return wrappedValue;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Request to get() with timeout " + timeout + " (" + (Object)((Object)unit) + ")"));
        }
        Object returnValueFromBeanProvider = super.get(timeout, unit);
        V wrappedValue = this.getWrappedFuture(returnValueFromBeanProvider);
        return wrappedValue;
    }

    private V getWrappedFuture(Object returnValueFromBeanProvider) throws InterruptedException, ExecutionException {
        if (returnValueFromBeanProvider == null) {
            return null;
        }
        if (!(returnValueFromBeanProvider instanceof Future)) {
            throw new RuntimeException("Bean provider has not specified a return value of type " + Future.class.getName() + ", was instead: " + returnValueFromBeanProvider);
        }
        Future result = (Future)returnValueFromBeanProvider;
        Object unwrappedReturnValue = result.get();
        return unwrappedReturnValue;
    }
}

