/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.effigy.dsl;

import java.lang.reflect.Method;
import javax.interceptor.InvocationContext;
import org.jboss.ejb3.effigy.InterceptorEffigy;
import org.jboss.ejb3.effigy.dsl.InterceptorEffigyImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorFactory {
    private InterceptorEffigyImpl interceptorEffigy = new InterceptorEffigyImpl();

    InterceptorFactory() {
    }

    private static String argumentTypesToString(Class<?> ... argTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = argTypes[i]) == null ? "null" : c.getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }

    private static boolean arrayContentsAssignable(Class[] a1, Class[] a2) {
        if (a1 == null) {
            return a2 == null || a2.length == 0;
        }
        if (a2 == null) {
            return a1.length == 0;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i].isAssignableFrom(a2[i])) continue;
            return false;
        }
        return true;
    }

    public InterceptorFactory aroundInvoke(String methodName) throws NoSuchMethodException {
        this.interceptorEffigy.addAroundInvoke(this.method(methodName));
        return this;
    }

    public InterceptorEffigy effigy() {
        return this.interceptorEffigy;
    }

    public static InterceptorFactory interceptor(Class<?> interceptorClass) {
        InterceptorFactory factory = new InterceptorFactory();
        factory.interceptorClass(interceptorClass);
        return factory;
    }

    public InterceptorFactory interceptorClass(Class<?> cls) {
        this.interceptorEffigy.setInterceptorClass(cls);
        return this;
    }

    private Method method(String methodName) throws NoSuchMethodException {
        Method method;
        block4: {
            Class<?> interceptorClass = this.interceptorEffigy.getInterceptorClass();
            try {
                method = interceptorClass.getMethod(methodName, InvocationContext.class);
            }
            catch (NoSuchMethodException e) {
                try {
                    method = interceptorClass.getDeclaredMethod(methodName, InvocationContext.class);
                    method.setAccessible(true);
                }
                catch (NoSuchMethodException e2) {
                    method = InterceptorFactory.searchMethods(interceptorClass.getDeclaredMethods(), methodName, InvocationContext.class);
                    if (method != null) break block4;
                    throw new NoSuchMethodException(interceptorClass.getName() + "." + methodName + InterceptorFactory.argumentTypesToString(InvocationContext.class));
                }
            }
        }
        return method;
    }

    public InterceptorFactory postConstruct(String methodName) throws NoSuchMethodException {
        this.interceptorEffigy.addPostConstruct(this.method(methodName));
        return this;
    }

    private static Method searchMethods(Method[] methods, String name, Class<?> ... parameterTypes) {
        Method res = null;
        String internedName = name.intern();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (m.getName() != internedName || !InterceptorFactory.arrayContentsAssignable(parameterTypes, m.getParameterTypes()) || res != null && !res.getReturnType().isAssignableFrom(m.getReturnType())) continue;
            res = m;
        }
        return res;
    }
}

