/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded.impl.standalone;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.ejb.spi.EJBContainerProvider;

public class JBossStandaloneEJBContainerProvider
implements EJBContainerProvider {
    private static void addClassPath(List<URL> cp, String dirname) {
        try {
            File[] files;
            File dir = new File(dirname);
            if (!dir.exists()) {
                throw new EJBException("Can't find directory " + dir.getAbsolutePath());
            }
            for (File f : files = dir.listFiles()) {
                cp.add(f.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new EJBException((Exception)e);
        }
    }

    public EJBContainer createEJBContainer(Map<?, ?> properties) throws EJBException {
        String jbossHome = System.getenv("JBOSS_HOME");
        if (jbossHome == null) {
            jbossHome = System.getProperty("jboss.home");
        }
        if (jbossHome == null) {
            throw new EJBException("Neither JBOSS_HOME nor jboss.home is set");
        }
        String serverConfig = System.getProperty("embedded.server.name", "default");
        ArrayList<URL> cp = new ArrayList<URL>();
        JBossStandaloneEJBContainerProvider.addClassPath(cp, jbossHome + "/lib");
        JBossStandaloneEJBContainerProvider.addClassPath(cp, jbossHome + "/common/lib");
        JBossStandaloneEJBContainerProvider.addClassPath(cp, jbossHome + "/server/" + serverConfig + "/lib");
        JBossStandaloneEJBContainerProvider.addClassPath(cp, jbossHome + "/client");
        try {
            cp.add(new File(jbossHome + "/server/" + serverConfig + "/deployers/jboss-jca.deployer/jboss-jca-deployer.jar").toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new EJBException((Exception)e);
        }
        String embeddedClassPath = System.getProperty("embedded.class.path");
        if (embeddedClassPath != null) {
            String[] classPathEntries;
            for (String s : classPathEntries = embeddedClassPath.split(File.pathSeparator)) {
                try {
                    cp.add(new File(s).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new EJBException((Exception)e);
                }
            }
        }
        URLClassLoader loader = new URLClassLoader(cp.toArray(new URL[0]), ClassLoader.getSystemClassLoader());
        try {
            assert (Resource.class.getMethod("lookup", new Class[0]) != null);
            assert (loader.loadClass(EJBContainer.class.getName()).equals(EJBContainer.class));
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> cls = loader.loadClass("org.jboss.ejb3.embedded.sub.JBossSubmersibleEJBContainer");
            Method createMethod = cls.getMethod("createEJBContainer", Map.class, URLClassLoader.class, String.class, String.class);
            return (EJBContainer)createMethod.invoke(null, properties, loader, jbossHome, serverConfig);
        }
        catch (ClassNotFoundException e) {
            throw new EJBException((Exception)e);
        }
        catch (NoSuchMethodException e) {
            throw new EJBException((Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new EJBException((Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new EJBException((Exception)e);
        }
    }
}

