/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded.sub;

import java.io.File;
import java.net.URLClassLoader;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.bootstrap.api.as.config.JBossASServerConfig;
import org.jboss.ejb3.embedded.impl.base.scanner.ClassPathEjbJarScanner;
import org.jboss.embedded.api.server.JBossASEmbeddedServer;
import org.jboss.embedded.api.server.JBossASEmbeddedServerFactory;

public class JBossSubmersibleEJBContainer
extends EJBContainer {
    private JBossASEmbeddedServer server;
    private Context context;

    protected JBossSubmersibleEJBContainer(JBossASEmbeddedServer server, Context context) {
        this.server = server;
        this.context = context;
    }

    private static Class<?> cls(ClassLoader loader, String className) {
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new EJBException((Exception)e);
        }
    }

    public void close() {
        try {
            this.server.shutdown();
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public static EJBContainer createEJBContainer(Map<?, ?> properties, URLClassLoader loader, String jbossHome, String serverName) throws EJBException {
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        String[] modules = ClassPathEjbJarScanner.getEjbJars();
        String bindAddress = System.getProperty("embedded.bind.address", "localhost");
        Thread.currentThread().setContextClassLoader(loader);
        JBossASEmbeddedServer server = JBossASEmbeddedServerFactory.createServer((ClassLoader)loader);
        JBossASServerConfig config = (JBossASServerConfig)server.getConfiguration();
        config.jbossHome(jbossHome);
        config.serverName(serverName);
        config.bindAddress(bindAddress);
        try {
            server.start();
            InitialContext context = new InitialContext();
            for (String m : modules) {
                server.deploy(new File[]{new File(m)});
            }
            return new JBossSubmersibleEJBContainer(server, context);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public Context getContext() {
        return this.context;
    }
}

