/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.PerVmAdvice;
import org.jboss.aspects.currentinvocation.CurrentInvocationInterceptor;
import org.jboss.ejb3.interceptors.aop.ExtendedAdvisor;
import org.jboss.ejb3.interceptors.aop.ExtendedAdvisorHelper;
import org.jboss.ejb3.interceptors.aop.InvocationContextInterceptor;
import org.jboss.ejb3.interceptors.aop.LifecycleCallbackBeanMethodInterceptor;
import org.jboss.ejb3.interceptors.aop.LifecycleCallbackInterceptorMethodInterceptor;
import org.jboss.ejb3.interceptors.container.BeanContext;
import org.jboss.ejb3.interceptors.lang.ClassHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleCallbacks {
    public static Interceptor[] createLifecycleCallbackInterceptors(Advisor advisor, List<Class<?>> lifecycleInterceptorClasses, BeanContext<?> component, Class<? extends Annotation> lifecycleAnnotationType) throws Exception {
        ArrayList<Object> interceptors = new ArrayList<Object>();
        interceptors.add(new CurrentInvocationInterceptor());
        interceptors.add(PerVmAdvice.generateInterceptor(null, (Object)new InvocationContextInterceptor(), (String)"setup"));
        for (Class<?> interceptorClass : lifecycleInterceptorClasses) {
            Object interceptor = component.getInterceptor(interceptorClass);
            ExtendedAdvisor interceptorAdvisor = ExtendedAdvisorHelper.getExtendedAdvisor(advisor, interceptor);
            HashSet<Class<?>> classes = null;
            for (Method interceptorMethod : ClassHelper.getAllMethods(interceptorClass)) {
                if (ClassHelper.isOverridden(interceptorClass, interceptorMethod) || !interceptorAdvisor.isAnnotationPresent(interceptorClass, interceptorMethod, lifecycleAnnotationType)) continue;
                classes = LifecycleCallbacks.checkClass(classes, interceptorMethod, advisor, lifecycleAnnotationType);
                interceptors.add(new LifecycleCallbackInterceptorMethodInterceptor(interceptor, interceptorMethod));
            }
        }
        Class beanClass = advisor.getClazz();
        HashSet<Class<?>> classes = null;
        for (Method beanMethod : ClassHelper.getAllMethods(beanClass)) {
            if (ClassHelper.isOverridden(beanClass, beanMethod) || !advisor.hasAnnotation(beanMethod, lifecycleAnnotationType)) continue;
            classes = LifecycleCallbacks.checkClass(classes, beanMethod, advisor, lifecycleAnnotationType);
            interceptors.add(new LifecycleCallbackBeanMethodInterceptor(beanMethod));
        }
        return interceptors.toArray(new Interceptor[0]);
    }

    private static HashSet<Class<?>> checkClass(HashSet<Class<?>> classes, Method m, Advisor advisor, Class<? extends Annotation> lifecycleAnnotationType) {
        if (classes != null) {
            if (classes.contains(m.getDeclaringClass())) {
                String type = null;
                if (lifecycleAnnotationType == PostConstruct.class) {
                    type = "post-construct";
                } else if (lifecycleAnnotationType == PreDestroy.class) {
                    type = "pre-destroy";
                } else if (lifecycleAnnotationType == PostActivate.class) {
                    type = "post-activate";
                } else if (lifecycleAnnotationType == PrePassivate.class) {
                    type = "pre-passivate";
                }
                throw new RuntimeException("More than one '" + type + "' method in " + advisor.getName());
            }
        } else {
            classes = new HashSet();
        }
        classes.add(m.getDeclaringClass());
        return classes;
    }
}

