/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.aop;

import java.util.Arrays;
import java.util.List;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorSequencer
implements Interceptor {
    private static final Logger log = Logger.getLogger(InterceptorSequencer.class);
    private Interceptor[] interceptors;

    public InterceptorSequencer(List<Interceptor> interceptors) {
        this(interceptors.toArray(new Interceptor[0]));
    }

    public InterceptorSequencer(Interceptor[] interceptors) {
        assert (interceptors != null);
        this.interceptors = interceptors;
    }

    public Object aroundInvoke(Invocation invocation) throws Throwable {
        log.debug((Object)("aroundInvoke " + invocation));
        return this.invoke(invocation);
    }

    public String getName() {
        return "InterceptorSequence";
    }

    @Deprecated
    public Object invoke(Invocation invocation) throws Throwable {
        if (log.isTraceEnabled()) {
            log.trace((Object)("interceptors " + Arrays.toString(this.interceptors)));
        }
        Invocation newInvocation = invocation.getWrapper(this.interceptors);
        return newInvocation.invokeNext();
    }

    public Object postConstruct(Invocation invocation) throws Throwable {
        return this.invoke(invocation);
    }

    public String toString() {
        return super.toString() + "[interceptors=" + Arrays.toString(this.interceptors) + "]";
    }
}

