/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.direct;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jboss.aop.Domain;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.MethodHashing;
import org.jboss.ejb3.interceptors.container.AbstractContainer;
import org.jboss.ejb3.interceptors.container.BeanContext;
import org.jboss.ejb3.interceptors.container.ManagedObjectAdvisor;
import org.jboss.ejb3.interceptors.direct.IndirectContainer;
import org.jboss.ejb3.interceptors.lang.ClassHelper;
import org.jboss.ejb3.interceptors.registry.InterceptorRegistry;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDirectContainer<T, C extends AbstractDirectContainer<T, C>>
extends AbstractContainer<T, C> {
    private static final Logger log = Logger.getLogger(AbstractDirectContainer.class);

    protected AbstractDirectContainer() {
    }

    protected AbstractDirectContainer(String name, Domain domain, Class<? extends T> beanClass) {
        super(name, domain, beanClass);
    }

    protected AbstractDirectContainer(String name, String domainName, Class<? extends T> beanClass) {
        super(name, domainName, beanClass);
    }

    public BeanContext<T> construct() throws SecurityException, NoSuchMethodException {
        return this.construct((Object[])null, null);
    }

    public BeanContext<T> construct(Object[] initargs, Class<?>[] parameterTypes) throws SecurityException, NoSuchMethodException {
        ManagedObjectAdvisor advisor = this.getAdvisor();
        Constructor constructor = advisor.getClazz().getConstructor(parameterTypes);
        BeanContext targetObject = this.construct(constructor, initargs);
        if (targetObject instanceof IndirectContainer) {
            ((IndirectContainer)((Object)targetObject)).setDirectContainer(this);
        }
        return targetObject;
    }

    @Override
    public void destroy(BeanContext<T> bean) {
        super.destroy(bean);
    }

    @Override
    public Class<? extends T> getBeanClass() {
        return super.getBeanClass();
    }

    @Override
    public InterceptorRegistry getInterceptorRegistry() {
        return super.getInterceptorRegistry();
    }

    @Override
    public Object invoke(BeanContext<T> target, Method method, Object[] arguments) throws Throwable {
        return super.invoke(target, method, arguments);
    }

    @Override
    public <R> R invoke(BeanContext<T> target, String methodName, Object ... args) throws Throwable {
        Method method = ClassHelper.getMethod(target.getInstance().getClass(), methodName);
        return (R)this.invoke(target, method, args);
    }

    public Object invokeIndirect(Object target, Method method, Object[] arguments) throws Throwable {
        long methodHash = MethodHashing.calculateHash((Method)method);
        MethodInfo info = this.getAdvisor().getMethodInfo(methodHash);
        if (info == null) {
            throw new IllegalArgumentException("method " + method + " is not under advisement by " + this);
        }
        MethodInvocation invocation = new MethodInvocation(info, info.getInterceptors()){

            public Object invokeTarget() throws Throwable {
                return null;
            }
        };
        invocation.setArguments(arguments);
        invocation.setTargetObject(target);
        return invocation.invokeNext();
    }
}

