/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.registry;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptors;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.interceptors.aop.annotation.DefaultInterceptors;
import org.jboss.ejb3.interceptors.aop.annotation.InterceptorOrder;
import org.jboss.ejb3.interceptors.lang.ClassHelper;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorRegistry {
    private static final Logger log = Logger.getLogger(InterceptorRegistry.class);
    private Advisor advisor;
    private List<Class<?>> interceptorClasses = new ArrayList();
    private List<Class<?>> readOnlyInterceptorClasses = Collections.unmodifiableList(this.interceptorClasses);
    private List<Class<?>> lifecycleInterceptorClasses = new ArrayList();
    private List<Class<?>> readOnlyLifecycleInterceptorClasses = Collections.unmodifiableList(this.lifecycleInterceptorClasses);
    private Map<Method, List<Class<?>>> applicableInterceptorClasses = new HashMap();

    public InterceptorRegistry(Advisor advisor) {
        assert (advisor != null) : "advisor is null";
        this.advisor = advisor;
        this.initialize();
    }

    public List<Class<?>> getApplicableInterceptorClasses(Method method) {
        List<Class<?>> methodApplicableInterceptorClasses = this.applicableInterceptorClasses.get(method);
        log.warn((Object)("applicable interceptors is non-existent for " + method));
        return methodApplicableInterceptorClasses;
    }

    public List<Class<?>> getInterceptorClasses() {
        return this.readOnlyInterceptorClasses;
    }

    public List<Class<?>> getLifecycleInterceptorClasses() {
        return this.readOnlyLifecycleInterceptorClasses;
    }

    private void initialize() {
        DefaultInterceptors defaultInterceptorsAnnotation = (DefaultInterceptors)this.advisor.resolveAnnotation(DefaultInterceptors.class);
        ArrayList defaultInterceptorClasses = new ArrayList();
        if (defaultInterceptorsAnnotation != null) {
            for (Class<?> defaultInterceptorClass : defaultInterceptorsAnnotation.value()) {
                defaultInterceptorClasses.add(defaultInterceptorClass);
            }
        }
        log.debug((Object)("Found default interceptors " + defaultInterceptorClasses));
        List<Class<Object>> lifecycleInterceptorClasses = new ArrayList<Class>();
        if (!InterceptorRegistry.isExcludedDefaultInterceptors(this.advisor)) {
            lifecycleInterceptorClasses.addAll(defaultInterceptorClasses);
        }
        Interceptors interceptorsAnnotation = (Interceptors)this.advisor.resolveAnnotation(Interceptors.class);
        ArrayList<Class> classInterceptorClasses = new ArrayList<Class>();
        if (interceptorsAnnotation != null) {
            for (Class classInterceptorClass : interceptorsAnnotation.value()) {
                classInterceptorClasses.add(classInterceptorClass);
                if (lifecycleInterceptorClasses.contains(classInterceptorClass)) continue;
                lifecycleInterceptorClasses.add(classInterceptorClass);
            }
        }
        log.debug((Object)("Found class interceptors " + classInterceptorClasses));
        InterceptorOrder order = (InterceptorOrder)this.advisor.resolveAnnotation(InterceptorOrder.class);
        if (order != null) {
            List orderedInterceptorClasses = Arrays.asList(order.value());
            if (!orderedInterceptorClasses.containsAll(lifecycleInterceptorClasses)) {
                throw new IllegalStateException("EJB3 12.8.2 footnote 59: all applicable lifecycle interceptors must be listed in the interceptor order");
            }
            lifecycleInterceptorClasses = orderedInterceptorClasses;
        }
        this.lifecycleInterceptorClasses.addAll(lifecycleInterceptorClasses);
        for (Class interceptorClass : lifecycleInterceptorClasses) {
            if (this.interceptorClasses.contains(interceptorClass)) continue;
            this.interceptorClasses.add(interceptorClass);
        }
        Class beanClass = this.advisor.getClazz();
        for (Method beanMethod : ClassHelper.getAllMethods(beanClass)) {
            interceptorsAnnotation = (Interceptors)this.advisor.resolveAnnotation(beanMethod, Interceptors.class);
            ArrayList<Class> methodInterceptorClasses = new ArrayList<Class>();
            if (interceptorsAnnotation != null) {
                for (Class interceptorClass : interceptorsAnnotation.value()) {
                    methodInterceptorClasses.add(interceptorClass);
                }
            }
            List<Class<Object>> methodApplicableInterceptorClasses = new ArrayList<Class>();
            if (!InterceptorRegistry.isExcludeDefaultInterceptors(this.advisor, beanMethod)) {
                methodApplicableInterceptorClasses.addAll(defaultInterceptorClasses);
            }
            if (!InterceptorRegistry.isExcludeClassInterceptors(this.advisor, beanMethod)) {
                methodApplicableInterceptorClasses.addAll(classInterceptorClasses);
            }
            methodApplicableInterceptorClasses.addAll(methodInterceptorClasses);
            InterceptorOrder order2 = (InterceptorOrder)this.advisor.resolveAnnotation(beanMethod, InterceptorOrder.class);
            if (order2 == null) {
                order2 = (InterceptorOrder)this.advisor.resolveAnnotation(InterceptorOrder.class);
            }
            if (order2 != null) {
                List orderedInterceptorClasses = Arrays.asList(order2.value());
                if (!orderedInterceptorClasses.containsAll(methodApplicableInterceptorClasses)) {
                    throw new IllegalStateException("EJB3 12.8.2 footnote 59: all applicable method interceptors must be listed in the interceptor order");
                }
                methodApplicableInterceptorClasses = orderedInterceptorClasses;
            }
            this.applicableInterceptorClasses.put(beanMethod, methodApplicableInterceptorClasses);
            for (Class interceptorClass : methodApplicableInterceptorClasses) {
                if (this.interceptorClasses.contains(interceptorClass)) continue;
                this.interceptorClasses.add(interceptorClass);
            }
        }
    }

    private static final boolean isExcludeClassInterceptors(Advisor advisor, Method method) {
        return advisor.hasAnnotation(method, ExcludeClassInterceptors.class) || advisor.resolveAnnotation(ExcludeClassInterceptors.class) != null;
    }

    private static final boolean isExcludeDefaultInterceptors(Advisor advisor, Method method) {
        return advisor.hasAnnotation(method, ExcludeDefaultInterceptors.class) || InterceptorRegistry.isExcludedDefaultInterceptors(advisor);
    }

    private static final boolean isExcludedDefaultInterceptors(Advisor advisor) {
        return advisor.resolveAnnotation(ExcludeDefaultInterceptors.class) != null;
    }
}

