/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.aop;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;

public class LifecycleCallbackBeanMethodInterceptor
implements Interceptor {
    private Method method;

    public LifecycleCallbackBeanMethodInterceptor(Method lifecycleCallbackMethod) {
        assert (lifecycleCallbackMethod != null) : "lifecycleCallbackMethod is null";
        assert (lifecycleCallbackMethod.getReturnType() == Void.TYPE) : "return type must be void";
        assert (lifecycleCallbackMethod.getParameterTypes().length == 0) : "wrong parameter signature";
        this.method = lifecycleCallbackMethod;
    }

    public String getName() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        try {
            boolean accessible = this.method.isAccessible();
            this.method.setAccessible(true);
            try {
                this.method.invoke(invocation.getTargetObject(), new Object[0]);
            }
            finally {
                this.method.setAccessible(accessible);
            }
            invocation.invokeNext();
            return null;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

