/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.effigy;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.ejb3.effigy.InterceptorEffigy;
import org.jboss.ejb3.interceptors.dsl.InterceptorReferenceFactory;
import org.jboss.ejb3.interceptors.dsl.MethodMetadataFactory;
import org.jboss.ejb3.interceptors.effigy.SimpleClassMetadata;
import org.jboss.interceptor.spi.metadata.ClassMetadata;
import org.jboss.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.interceptor.spi.metadata.InterceptorReference;
import org.jboss.interceptor.spi.metadata.MethodMetadata;
import org.jboss.interceptor.spi.model.InterceptionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InterceptorInterceptorMetadata
implements InterceptorMetadata<ClassMetadata<?>> {
    private static final long serialVersionUID = 1L;
    private SimpleClassMetadata classMetadata;
    private InterceptorReference<ClassMetadata<?>> interceptorReference;
    private Map<InterceptionType, List<MethodMetadata>> interceptorMethods = new ConcurrentHashMap<InterceptionType, List<MethodMetadata>>();

    InterceptorInterceptorMetadata(InterceptorEffigy interceptor) {
        this.classMetadata = new SimpleClassMetadata(interceptor.getInterceptorClass());
        this.interceptorReference = InterceptorReferenceFactory.interceptorReference(this.classMetadata);
        InterceptorInterceptorMetadata.putInIfExists(this.interceptorMethods, InterceptionType.AROUND_INVOKE, MethodMetadataFactory.methods(interceptor.getAroundInvokes()));
        InterceptorInterceptorMetadata.putInIfExists(this.interceptorMethods, InterceptionType.POST_CONSTRUCT, MethodMetadataFactory.methods(interceptor.getPostConstructs()));
        InterceptorInterceptorMetadata.putInIfExists(this.interceptorMethods, InterceptionType.PRE_DESTROY, MethodMetadataFactory.methods(interceptor.getPreDestroys()));
    }

    public InterceptorReference<ClassMetadata<?>> getInterceptorReference() {
        return this.interceptorReference;
    }

    public ClassMetadata<?> getInterceptorClass() {
        return this.classMetadata;
    }

    public List<MethodMetadata> getInterceptorMethods(InterceptionType interceptionType) {
        return this.interceptorMethods.get(interceptionType);
    }

    public boolean isEligible(InterceptionType interceptionType) {
        throw new RuntimeException("NYI: org.jboss.ejb3.interceptors.effigy.InterceptorInterceptorMetadata.isEligible");
    }

    public boolean isTargetClass() {
        throw new RuntimeException("NYI: org.jboss.ejb3.interceptors.effigy.InterceptorInterceptorMetadata.isTargetClass");
    }

    private static <K, V> void putInIfExists(Map<K, V> map, K key, V value) {
        if (value == null) {
            return;
        }
        map.put(key, value);
    }
}

