/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.nointerface.deployers;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.ejb.LocalBean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.jboss.beans.metadata.api.model.FromContext;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.deployers.Ejb3MetadataProcessingDeployer;
import org.jboss.ejb3.nointerface.mc.NoInterfaceViewJNDIBinder;
import org.jboss.logging.Logger;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

public class EJB3NoInterfaceDeployer
extends AbstractDeployer {
    private static Logger logger = Logger.getLogger(EJB3NoInterfaceDeployer.class);
    private static final String INPUT = Ejb3MetadataProcessingDeployer.OUTPUT;

    public EJB3NoInterfaceDeployer() {
        this.setStage(DeploymentStages.REAL);
        this.setInput(JBossMetaData.class);
        this.addInput(INPUT);
        this.addOutput(BeanMetaData.class);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        JBossMetaData metaData;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Deploying unit " + unit.getName()));
        }
        if ((metaData = (JBossMetaData)unit.getAttachment(INPUT, JBossMetaData.class)) == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("No JBossMetadata for unit : " + unit.getName()));
            }
            return;
        }
        JBossEnterpriseBeansMetaData beans = metaData.getEnterpriseBeans();
        for (JBossEnterpriseBeanMetaData bean : beans) {
            if (!bean.isSession()) continue;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Found bean of type session: " + bean.getEjbClass() + " in unit " + unit.getName()));
            }
            if (!(bean instanceof JBossSessionBean31MetaData)) continue;
            this.deploy(unit, (JBossSessionBean31MetaData)bean);
        }
    }

    private void deploy(DeploymentUnit unit, JBossSessionBean31MetaData sessionBeanMetaData) throws DeploymentException {
        try {
            if (!sessionBeanMetaData.isNoInterfaceBean()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Bean class " + sessionBeanMetaData.getEjbClass() + " is not eligible for no-interface view"));
                }
                return;
            }
            Class<?> beanClass = Class.forName(sessionBeanMetaData.getEjbClass(), false, unit.getClassLoader());
            String containerMCBeanName = sessionBeanMetaData.getContainerName();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Container name for bean " + sessionBeanMetaData.getEjbName() + " in unit " + unit + " is " + containerMCBeanName));
            }
            if (containerMCBeanName == null) {
                containerMCBeanName = this.getContainerName(unit, (JBossSessionBeanMetaData)sessionBeanMetaData);
            }
            NoInterfaceViewJNDIBinder<JBossSessionBean31MetaData> noInterfaceViewJNDIBinder = NoInterfaceViewJNDIBinder.getNoInterfaceViewJndiBinder(new InitialContext(), beanClass, sessionBeanMetaData);
            String noInterfaceViewMCBeanName = unit.getName() + "$" + sessionBeanMetaData.getEjbName();
            BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)noInterfaceViewMCBeanName, (String)noInterfaceViewJNDIBinder.getClass().getName());
            builder.setConstructorValue(noInterfaceViewJNDIBinder);
            AbstractInjectionValueMetaData injectMetaData = new AbstractInjectionValueMetaData((Object)containerMCBeanName);
            injectMetaData.setDependentState(ControllerState.DESCRIBED);
            injectMetaData.setFromContext(FromContext.CONTEXT);
            builder.addPropertyMetaData("endpointContext", (ValueMetaData)injectMetaData);
            unit.addAttachment(BeanMetaData.class + ":" + noInterfaceViewMCBeanName, (Object)builder.getBeanMetaData());
            logger.debug((Object)("No-interface JNDI binder for container " + containerMCBeanName + " has been created and added to the deployment unit " + unit));
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException((String)("Could not create no-interface view for " + sessionBeanMetaData.getEjbClass() + " in unit " + unit.getName()), (Throwable)t);
        }
    }

    public void undeploy(DeploymentUnit unit, JBossMetaData deployment) {
    }

    private boolean isEligibleForNoInterfaceView(DeploymentUnit unit, JBossSessionBeanMetaData sessionBeanMetadata) throws Exception {
        String ejbClassName = sessionBeanMetadata.getEjbClass();
        Class<?> beanClass = Class.forName(ejbClassName, false, unit.getClassLoader());
        if (beanClass.getAnnotation(LocalBean.class) != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Bean class " + ejbClassName + " in unit " + unit + " is marked as @LocalBean"));
            }
            return true;
        }
        if (sessionBeanMetadata.getBusinessLocals() != null && !sessionBeanMetadata.getBusinessLocals().isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Bean " + sessionBeanMetadata.getEjbClass() + " has business local, hence not eligible for no-interface view"));
            }
            return false;
        }
        if (sessionBeanMetadata.getBusinessRemotes() != null && !sessionBeanMetadata.getBusinessRemotes().isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Bean " + sessionBeanMetadata.getEjbClass() + " has business remote, hence not eligible for no-interface view"));
            }
            return false;
        }
        if (sessionBeanMetadata.getHome() != null || sessionBeanMetadata.getLocalHome() != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Bean " + sessionBeanMetadata.getEjbClass() + " has 2.x home/local-home, hence not eligible for no-interface view"));
            }
            return false;
        }
        if (this.doesBeanImplementAnyInterfaces(beanClass)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Bean " + sessionBeanMetadata.getEjbClass() + " implements interfaces (other than the one's excluded as per section 4.9.8 of EJB3.1 spec), hence not eligible for no-interface view"));
            }
            return false;
        }
        return true;
    }

    private boolean doesBeanImplementAnyInterfaces(Class<?> beanClass) {
        Class<?>[] interfaces = beanClass.getInterfaces();
        if (interfaces.length == 0) {
            return false;
        }
        ArrayList implementedInterfaces = new ArrayList(Arrays.asList(interfaces));
        Iterator implementedInterfacesIterator = implementedInterfaces.iterator();
        while (implementedInterfacesIterator.hasNext()) {
            Class implementedInterface = (Class)implementedInterfacesIterator.next();
            if (!implementedInterface.equals(Serializable.class) && !implementedInterface.equals(Externalizable.class) && !implementedInterface.getName().startsWith("javax.ejb.")) continue;
            implementedInterfacesIterator.remove();
        }
        return !implementedInterfaces.isEmpty();
    }

    private String getContainerName(DeploymentUnit unit, JBossSessionBeanMetaData sessionBeanMetadata) throws MalformedObjectNameException {
        StringBuilder containerName = new StringBuilder("jboss.j2ee:service=EJB3,");
        DeploymentUnit toplevelUnit = unit.getTopLevel();
        if (toplevelUnit != null && this.isEar(toplevelUnit)) {
            containerName.append("ear=");
            containerName.append(toplevelUnit.getSimpleName());
            containerName.append(",");
        }
        if (unit.getSimpleName() == null) {
            containerName.append("*");
        } else {
            containerName.append("jar=");
            containerName.append(unit.getSimpleName());
        }
        containerName.append(",name=");
        containerName.append(sessionBeanMetadata.getEjbName());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Container name generated for ejb = " + sessionBeanMetadata.getEjbName() + " in unit " + unit + " is " + containerName));
        }
        ObjectName containerJMXName = new ObjectName(containerName.toString());
        return containerJMXName.getCanonicalName();
    }

    private boolean isEar(DeploymentUnit unit) {
        return unit.getSimpleName().endsWith(".ear") || unit.getAttachment(JBossAppMetaData.class) != null;
    }
}

