/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.nointerface.mc;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.ejb3.nointerface.factory.MCAwareStatefulNoInterfaceViewFactory;
import org.jboss.ejb3.nointerface.mc.NoInterfaceViewJNDIBinder;
import org.jboss.ejb3.nointerface.objectfactory.StatefulNoInterfaceViewObjectFactory;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.util.naming.NonSerializableFactory;

public class StatefulNoInterfaceJNDIBinder<T extends JBossSessionBean31MetaData>
extends NoInterfaceViewJNDIBinder<T> {
    private static Logger logger = Logger.getLogger(StatefulNoInterfaceJNDIBinder.class);
    private static final String NO_INTERFACE_STATEFUL_PROXY_FACTORY_JNDI_NAME_SUFFIX = "/no-interface-stateful-proxyfactory";

    protected StatefulNoInterfaceJNDIBinder(Context ctx, Class<?> beanClass, T sessionBeanMetadata) {
        super(ctx, beanClass, sessionBeanMetadata);
    }

    @Override
    public void bindNoInterfaceView() throws NamingException {
        logger.debug((Object)("Binding no-interface view statefulproxyfactory and the objectfactory for bean " + this.beanClass));
        MCAwareStatefulNoInterfaceViewFactory statefulNoInterfaceViewFactory = new MCAwareStatefulNoInterfaceViewFactory(this.beanClass, this.endpointContext);
        String statefulProxyFactoryJndiName = this.sessionBeanMetadata.getEjbName() + NO_INTERFACE_STATEFUL_PROXY_FACTORY_JNDI_NAME_SUFFIX;
        NonSerializableFactory.rebind((Context)this.jndiCtx, (String)statefulProxyFactoryJndiName, (Object)statefulNoInterfaceViewFactory, (boolean)true);
        Reference reference = new Reference("Object factory for no-interface view for stateful bean", StatefulNoInterfaceViewObjectFactory.class.getName(), null);
        StringRefAddr refAddr = new StringRefAddr("Stateful Proxy factory for no-interface view", statefulProxyFactoryJndiName);
        reference.add(refAddr);
        String noInterfaceJndiName = this.getJNDINameResolver().resolveNoInterfaceJNDIName(this.sessionBeanMetadata);
        this.jndiCtx.bind(noInterfaceJndiName, (Object)reference);
        logger.info((Object)("Bound the no-interface view for bean " + this.beanClass + " to jndi at " + noInterfaceJndiName));
    }

    @Override
    public void unbindNoInterfaceView() throws NamingException {
        String noInterfaceJndiName = this.getJNDINameResolver().resolveNoInterfaceJNDIName(this.sessionBeanMetadata);
        this.jndiCtx.unbind(noInterfaceJndiName);
        this.jndiCtx.unbind(this.sessionBeanMetadata.getEjbName() + NO_INTERFACE_STATEFUL_PROXY_FACTORY_JNDI_NAME_SUFFIX);
    }
}

