/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.recovery;

import com.arjuna.ats.arjuna.common.Configuration;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.recovery.RecoveryScan;
import com.arjuna.ats.arjuna.recovery.ScanThread;
import com.arjuna.ats.arjuna.utils.Utility;
import com.arjuna.ats.internal.arjuna.recovery.RecoveryManagerImple;
import com.arjuna.common.util.propertyservice.PropertyManager;
import com.arjuna.common.util.propertyservice.PropertyManagerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

public class RecoveryManager {
    public static final int INDIRECT_MANAGEMENT = 0;
    public static final int DIRECT_MANAGEMENT = 1;
    private RecoveryManagerImple _theImple = null;
    private int _mode;
    private static RecoveryManager _recoveryManager = null;
    private static boolean delayRecoveryManagerThread;

    public static final synchronized RecoveryManager manager() throws IllegalArgumentException {
        return RecoveryManager.manager(0);
    }

    public static final synchronized RecoveryManager manager(int mode) throws IllegalArgumentException {
        if (_recoveryManager == null) {
            _recoveryManager = new RecoveryManager(mode);
        } else if (_recoveryManager.mode() != mode) {
            throw new IllegalArgumentException();
        }
        return _recoveryManager;
    }

    public static synchronized void delayRecoveryManagerThread() {
        delayRecoveryManagerThread = true;
    }

    public final void scan() {
        this._theImple.scan();
    }

    public final void scan(RecoveryScan callback) {
        ScanThread st = new ScanThread(this._theImple, callback);
        st.start();
    }

    public final void stop() {
        this.stop(false);
    }

    public final void stop(boolean async) {
        this._theImple.stop(async);
    }

    public void suspendScan(boolean async) {
        this._theImple.suspendScan(async);
    }

    public void resumeScan() {
        this._theImple.resumeScan();
    }

    public void startRecoveryManagerThread() {
        this._theImple.start();
    }

    public final void addModule(RecoveryModule module) {
        this._theImple.addModule(module);
    }

    public final void removeModule(RecoveryModule module, boolean waitOnScan) {
        this._theImple.removeModule(module, waitOnScan);
    }

    public final Vector getModules() {
        return this._theImple.getModules();
    }

    public final int mode() {
        return this._mode;
    }

    public static InetAddress getRecoveryManagerHost() throws UnknownHostException {
        PropertyManager pm = PropertyManagerFactory.getPropertyManager((String)"com.arjuna.ats.propertymanager", (String)"recoverymanager");
        if (pm == null) {
            return InetAddress.getLocalHost();
        }
        String hostPropName = "com.arjuna.ats.arjuna.recovery.recoveryAddress";
        String host = pm.getProperty(hostPropName);
        return Utility.hostNameToInetAddress(host, "com.arjuna.ats.arjuna.recovery.RecoveryManager_2");
    }

    public static int getRecoveryManagerPort() {
        PropertyManager pm = PropertyManagerFactory.getPropertyManager((String)"com.arjuna.ats.propertymanager", (String)"recoverymanager");
        if (pm == null) {
            return 0;
        }
        String portPropName = "com.arjuna.ats.arjuna.recovery.recoveryPort";
        Integer port = Utility.lookupBoundedIntegerProperty(pm, portPropName, null, "com.arjuna.ats.arjuna.recovery.RecoveryManager_1", 0, 65535);
        if (port == null) {
            String portStr = pm.getProperty(portPropName);
            if (portStr == null || portStr.length() == 0) {
                port = 0;
            } else {
                throw new FatalError(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.recovery.RecoveryManager_5"));
            }
        }
        return port;
    }

    public static Socket getClientSocket() throws IOException {
        Socket socket = new Socket(RecoveryManager.getRecoveryManagerHost(), RecoveryManager.getRecoveryManagerPort());
        if (tsLogger.arjLogger.isInfoEnabled()) {
            tsLogger.arjLoggerI18N.info("com.arjuna.ats.arjuna.recovery.RecoveryManager_4", new Object[]{socket.getInetAddress().getHostAddress(), socket.getLocalPort()});
        }
        return socket;
    }

    public static void main(String[] args) {
        boolean testMode = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].compareTo("-help") == 0) {
                System.out.println("Usage: com.arjuna.ats.arjuna.recovery.RecoveryManager [-help] [-test] [-version]");
                System.exit(0);
            }
            if (args[i].compareTo("-version") == 0) {
                System.out.println("Version " + Configuration.version());
                System.exit(0);
            }
            if (args[i].compareTo("-test") != 0) continue;
            testMode = true;
        }
        try {
            RecoveryManager.manager();
            if (testMode) {
                System.out.println("Ready");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private RecoveryManager(int mode) {
        this._theImple = mode == 0 && !delayRecoveryManagerThread ? new RecoveryManagerImple(true) : new RecoveryManagerImple(false);
        this._mode = mode;
    }
}

