/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.arjunacore.jca;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple;
import com.arjuna.ats.jta.xa.XidImple;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class TxImporter {
    private static ConcurrentHashMap<Xid, TransactionImple> _transactions = new ConcurrentHashMap();

    public static TransactionImple importTransaction(Xid xid) throws XAException {
        return TxImporter.importTransaction(xid, 0);
    }

    public static TransactionImple importTransaction(Xid xid, int timeout) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        TransactionImple imported = TxImporter.getImportedTransaction(xid);
        if (imported == null) {
            imported = new TransactionImple(timeout, xid);
            _transactions.put(new XidImple(xid), imported);
        }
        return imported;
    }

    public static TransactionImple recoverTransaction(Uid actId) throws XAException {
        if (actId == null) {
            throw new IllegalArgumentException();
        }
        TransactionImple recovered = new TransactionImple(actId);
        TransactionImple tx = _transactions.get(recovered.baseXid());
        if (tx == null) {
            _transactions.put(recovered.baseXid(), recovered);
            recovered.recordTransaction();
            return recovered;
        }
        return tx;
    }

    public static TransactionImple getImportedTransaction(Xid xid) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        TransactionImple tx = _transactions.get(new XidImple(xid));
        if (tx == null) {
            return null;
        }
        if (!tx.activated()) {
            tx.recover();
            return tx;
        }
        return tx;
    }

    public static void removeImportedTransaction(Xid xid) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        _transactions.remove(new XidImple(xid));
    }
}

