/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.RecoveryConfiguration;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.internal.arjuna.Implementations;
import com.arjuna.ats.internal.arjuna.recovery.ExpiredEntryMonitor;
import com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery;
import com.arjuna.ats.internal.arjuna.recovery.RecActivatorLoader;
import com.arjuna.common.util.propertyservice.PropertyManagerFactory;
import java.io.IOException;
import java.util.Vector;

public class RecoveryManagerImple {
    private PeriodicRecovery _periodicRecovery;
    private RecActivatorLoader _recActivatorLoader;

    public RecoveryManagerImple(boolean threaded) {
        block10: {
            block9: {
                this._periodicRecovery = null;
                this._recActivatorLoader = null;
                String rmPropertyFile = RecoveryConfiguration.recoveryManagerPropertiesFile();
                try {
                    arjPropertyManager.propertyManager = PropertyManagerFactory.getPropertyManager((String)"com.arjuna.ats.propertymanager", (String)"recoverymanager");
                }
                catch (Exception ex) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block9;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.RecoveryManagerImple_1", new Object[]{ex});
                }
            }
            tsLogger.arjLogger.mergeFacilityCode(262144L);
            tsLogger.arjLoggerI18N.mergeFacilityCode(262144L);
            Implementations.initialise();
            if (this.isRecoveryManagerEndPointInUse()) {
                if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
                    try {
                        tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.recovery.fail", new Object[]{RecoveryManager.getRecoveryManagerHost(), RecoveryManager.getRecoveryManagerPort()});
                    }
                    catch (Throwable t) {
                        tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.internal.arjuna.recovery.fail", new Object[]{"unknown", "unknown"});
                    }
                }
                throw new FatalError("Recovery manager already active (or recovery port and address are in use)!");
            }
            this._recActivatorLoader = new RecActivatorLoader();
            ExpiredEntryMonitor.startUp();
            this._periodicRecovery = new PeriodicRecovery(threaded);
            try {
                if (tsLogger.arjLogger.isInfoEnabled()) {
                    Object[] objectArray = new Object[1];
                    RecoveryManagerImple recoveryManagerImple = this;
                    objectArray[0] = new Integer(recoveryManagerImple._periodicRecovery.getServerSocket().getLocalPort());
                    tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.recovery.ready", objectArray);
                }
            }
            catch (IOException ex) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block10;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.RecoveryManagerImple_2", new Object[]{ex});
            }
        }
    }

    public final void scan() {
        this._periodicRecovery.doWork();
    }

    public final void addModule(RecoveryModule module) {
        this._periodicRecovery.addModule(module);
    }

    public final void removeModule(RecoveryModule module, boolean waitOnScan) {
        this._periodicRecovery.removeModule(module, waitOnScan);
    }

    public final Vector getModules() {
        return this._periodicRecovery.getModules();
    }

    public void start() {
        if (!this._periodicRecovery.isAlive()) {
            this._periodicRecovery.start();
        }
    }

    public void stop(boolean async) {
        this._periodicRecovery.shutdown(async);
    }

    public void suspendScan(boolean async) {
        this._periodicRecovery.suspendScan(async);
    }

    public void resumeScan() {
        this._periodicRecovery.resumeScan();
    }

    public void finalize() {
        this.stop(true);
    }

    private final boolean isRecoveryManagerEndPointInUse() {
        try {
            PeriodicRecovery.getServerSocket();
            return false;
        }
        catch (Throwable e) {
            return true;
        }
    }
}

