/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.jts.jca;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jta.transaction.jts.subordinate.jca.TransactionImple;
import com.arjuna.ats.jta.xa.XidImple;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class TxImporter {
    private static ConcurrentHashMap<Xid, TransactionImple> _transactions = new ConcurrentHashMap();

    public static TransactionImple importTransaction(Xid xid) throws XAException {
        return TxImporter.importTransaction(xid, 0);
    }

    public static TransactionImple importTransaction(Xid xid, int timeout) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        TransactionImple imported = TxImporter.getImportedTransaction(xid);
        if (imported == null) {
            imported = new TransactionImple(timeout, xid);
            _transactions.put(new XidImple(xid), imported);
        }
        return imported;
    }

    public static TransactionImple recoverTransaction(Uid actId) throws XAException {
        if (actId == null) {
            throw new IllegalArgumentException();
        }
        TransactionImple recovered = new TransactionImple(actId);
        TransactionImple tx2 = _transactions.get(recovered.baseXid());
        if (tx2 == null) {
            recovered.recordTransaction();
            _transactions.put(recovered.baseXid(), recovered);
            return recovered;
        }
        return tx2;
    }

    public static TransactionImple getImportedTransaction(Xid xid) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        TransactionImple tx2 = _transactions.get(new XidImple(xid));
        if (tx2 == null) {
            return null;
        }
        if (tx2.baseXid() == null) {
            tx2.getControlWrapper().getImple().getImplHandle().activate();
            return tx2;
        }
        return tx2;
    }

    public static void removeImportedTransaction(Xid xid) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        _transactions.remove(new XidImple(xid));
    }
}

