/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.jts.subordinate;

import com.arjuna.ats.internal.jta.transaction.jts.AtomicTransaction;
import com.arjuna.ats.internal.jta.transaction.jts.subordinate.SubordinateAtomicTransaction;
import com.arjuna.ats.jta.logging.jtaLogger;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.omg.CosTransactions.NoTransaction;

public class TransactionImple
extends com.arjuna.ats.internal.jta.transaction.jts.TransactionImple {
    public TransactionImple(AtomicTransaction imported) {
        super(imported);
        TransactionImple.putTransaction(this);
    }

    public boolean equals(Object obj) {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.equals");
        }
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof TransactionImple) {
            return super.equals(obj);
        }
        return false;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException, IllegalStateException {
        throw new IllegalStateException();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        throw new IllegalStateException();
    }

    public int doPrepare() throws SystemException {
        try {
            SubordinateAtomicTransaction subAct = (SubordinateAtomicTransaction)this._theTransaction;
            if (!this.endSuspendedRMs()) {
                try {
                    this._theTransaction.rollbackOnly();
                }
                catch (NoTransaction ex) {
                    // empty catch block
                }
            }
            int res = subAct.doPrepare();
            switch (res) {
                case 1: 
                case 2: {
                    TransactionImple.removeTransaction(this);
                }
            }
            return res;
        }
        catch (ClassCastException ex) {
            return 11;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SystemException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doCommit() throws IllegalStateException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        try {
            SubordinateAtomicTransaction subAct = (SubordinateAtomicTransaction)this._theTransaction;
            int res = subAct.doCommit();
            switch (res) {
                case 6: 
                case 7: 
                case 12: {
                    return;
                }
                case 2: 
                case 4: {
                    throw new HeuristicRollbackException();
                }
                case 11: {
                    throw new HeuristicRollbackException();
                }
                case 13: 
                case 14: {
                    throw new HeuristicMixedException();
                }
                case 9: {
                    throw new IllegalStateException();
                }
                default: {
                    throw new HeuristicMixedException();
                }
            }
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            throw new IllegalStateException();
        }
        finally {
            TransactionImple.removeTransaction(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doRollback() throws IllegalStateException, HeuristicMixedException, HeuristicCommitException, SystemException {
        try {
            SubordinateAtomicTransaction subAct = (SubordinateAtomicTransaction)this._theTransaction;
            if (!this.endSuspendedRMs() && jtaLogger.loggerI18N.isWarnEnabled()) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.endsuspendfailed1");
            }
            int res = subAct.doRollback();
            switch (res) {
                case 2: 
                case 4: 
                case 11: {
                    return;
                }
                case 12: {
                    throw new HeuristicCommitException();
                }
                case 13: 
                case 14: {
                    throw new HeuristicMixedException();
                }
                default: {
                    throw new HeuristicMixedException();
                }
            }
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            throw new IllegalStateException();
        }
        finally {
            TransactionImple.removeTransaction(this);
        }
    }

    public void doOnePhaseCommit() throws IllegalStateException, HeuristicRollbackException {
        try {
            SubordinateAtomicTransaction subAct = (SubordinateAtomicTransaction)this._theTransaction;
            if (!this.endSuspendedRMs()) {
                try {
                    this._theTransaction.rollbackOnly();
                }
                catch (NoTransaction ex) {
                    // empty catch block
                }
            }
            int status = subAct.doOnePhaseCommit();
            TransactionImple.removeTransaction(this);
            switch (status) {
                case 7: 
                case 12: {
                    break;
                }
                default: {
                    throw new HeuristicRollbackException();
                }
                case 9: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            throw new IllegalStateException();
        }
    }

    public void doForget() throws IllegalStateException {
        try {
            SubordinateAtomicTransaction subAct = (SubordinateAtomicTransaction)this._theTransaction;
            subAct.doForget();
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            throw new IllegalStateException();
        }
    }

    public String toString() {
        if (this._theTransaction == null) {
            return "TransactionImple < jts-subordinate, NoTransaction >";
        }
        return "TransactionImple < jts-subordinate, " + this._theTransaction.get_uid() + " >";
    }

    protected void commitAndDisassociate() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException, IllegalStateException {
        throw new IllegalStateException();
    }

    protected void rollbackAndDisassociate() throws IllegalStateException, SecurityException, SystemException {
        throw new IllegalStateException();
    }
}

