/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.interposition.resources.arjuna;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.arjuna.template.HashList;
import com.arjuna.ats.internal.jts.interposition.ServerFactory;
import com.arjuna.ats.internal.jts.interposition.resources.arjuna.InterposedHierarchy;
import com.arjuna.ats.internal.jts.orbspecific.ControlImple;
import com.arjuna.ats.internal.jts.orbspecific.interposition.ServerControl;
import com.arjuna.ats.internal.jts.orbspecific.interposition.resources.arjuna.ServerNestedAction;
import com.arjuna.ats.internal.jts.orbspecific.interposition.resources.arjuna.ServerTopLevelAction;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import com.arjuna.common.util.logging.LogNoi18n;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TransIdentity;

public class Interposition {
    protected HashList _head = new HashList(11);
    private static Interposition __list = new Interposition();

    public void finalize() {
        this._head = null;
    }

    public static ControlImple create(PropagationContext context) throws SystemException {
        if (__list != null) {
            return __list.setupHierarchy(context);
        }
        return null;
    }

    public static boolean destroy(Uid act) {
        if (__list != null) {
            return __list.removeHierarchy(act);
        }
        return false;
    }

    public synchronized ControlImple setupHierarchy(PropagationContext context) throws SystemException {
        ControlImple controlPtr = null;
        Uid theUid = null;
        InterposedHierarchy proxyAction = null;
        theUid = context.parents.length == 0 ? Utility.otidToUid(context.current.otid) : Utility.otidToUid(context.parents[context.parents.length - 1].otid);
        proxyAction = this.present(theUid);
        if (proxyAction == null) {
            controlPtr = this.createHierarchy(context, theUid);
        } else {
            controlPtr = this.checkHierarchy(proxyAction, context);
            proxyAction = null;
        }
        return controlPtr;
    }

    protected final synchronized InterposedHierarchy present(Uid actUid) {
        return (InterposedHierarchy)this._head.lookFor(actUid);
    }

    protected synchronized ControlImple createHierarchy(PropagationContext ctx, Uid tlUid) throws SystemException {
        int depth = ctx.parents.length;
        ServerTopLevelAction action = null;
        Coordinator tmpCoord = null;
        Terminator tmpTerm = null;
        if (depth == 0) {
            tmpCoord = ctx.current.coord;
            tmpTerm = ctx.current.term;
        } else {
            tmpCoord = ctx.parents[depth - 1].coord;
            tmpTerm = ctx.parents[depth - 1].term;
        }
        if (tmpCoord == null) {
            return null;
        }
        ServerControl control = ServerFactory.create_transaction(tlUid, null, null, tmpCoord, tmpTerm, ctx.timeout);
        action = new ServerTopLevelAction(control);
        if (!action.valid()) {
            try {
                action.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new TRANSACTION_ROLLEDBACK();
        }
        InterposedHierarchy newElement = new InterposedHierarchy(action);
        this._head.add(newElement);
        if (depth > 0) {
            ServerNestedAction nestedAction = null;
            for (int i = depth - 2; i >= 0; --i) {
                tmpCoord = ctx.parents[i].coord;
                tmpTerm = ctx.parents[i].term;
                control = ServerFactory.create_subtransaction(Utility.otidToUid(ctx.parents[i].otid), tmpCoord, tmpTerm, control);
                nestedAction = new ServerNestedAction(control);
                if (!nestedAction.valid()) {
                    try {
                        nestedAction.rollback_subtransaction();
                        nestedAction = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw new TRANSACTION_ROLLEDBACK();
                }
                action.addChild(nestedAction);
                action = nestedAction;
            }
            tmpCoord = ctx.current.coord;
            tmpTerm = ctx.current.term;
            control = ServerFactory.create_subtransaction(Utility.otidToUid(ctx.current.otid), tmpCoord, tmpTerm, control);
            nestedAction = new ServerNestedAction(control);
            if (!nestedAction.valid()) {
                try {
                    nestedAction.rollback_subtransaction();
                    nestedAction = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw new TRANSACTION_ROLLEDBACK();
            }
            action.addChild(nestedAction);
        }
        if (jtsLogger.logger.isDebugEnabled()) {
            this.compareHierarchies(ctx, newElement);
        }
        return control;
    }

    protected synchronized ControlImple checkHierarchy(InterposedHierarchy hier, PropagationContext context) throws SystemException {
        ServerControl control = null;
        ServerTopLevelAction currentAction = hier.action();
        int depth = context.parents.length;
        int differenceIndex = -1;
        if (depth == 0) {
            control = hier.action().control();
        } else {
            Uid currentUid;
            ServerNestedAction nestedAction = null;
            for (int i = depth - 2; i >= 0; --i) {
                nestedAction = currentAction.getChild(Utility.otidToUid(context.parents[i].otid));
                if (nestedAction == null) {
                    differenceIndex = i;
                    break;
                }
                currentAction = nestedAction;
            }
            if (differenceIndex != -1) {
                control = currentAction.control();
                for (int j = differenceIndex; j >= 0; --j) {
                    Coordinator tmpCoord = context.parents[j].coord;
                    Terminator tmpTerm = context.parents[j].term;
                    control = ServerFactory.create_subtransaction(Utility.otidToUid(context.parents[j].otid), tmpCoord, tmpTerm, control);
                    nestedAction = new ServerNestedAction(control);
                    if (!nestedAction.valid()) {
                        try {
                            nestedAction.rollback();
                            nestedAction = null;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        throw new TRANSACTION_ROLLEDBACK();
                    }
                    currentAction.addChild(nestedAction);
                    currentAction = nestedAction;
                }
            }
            if ((nestedAction = currentAction.getChild(currentUid = Utility.otidToUid(context.current.otid))) == null) {
                control = currentAction.control();
                TransIdentity currentID = context.current;
                nestedAction = new ServerNestedAction(control = ServerFactory.create_subtransaction(currentUid, currentID.coord, currentID.term, control));
                if (!nestedAction.valid()) {
                    try {
                        nestedAction.rollback();
                        nestedAction = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw new TRANSACTION_ROLLEDBACK();
                }
                currentAction.addChild(nestedAction);
            } else {
                control = nestedAction.control();
            }
        }
        if (jtsLogger.logger.isDebugEnabled()) {
            this.compareHierarchies(context, hier);
        }
        return control;
    }

    protected final synchronized boolean removeHierarchy(Uid action) {
        InterposedHierarchy hier;
        InterposedHierarchy interposedHierarchy = hier = this._head != null ? (InterposedHierarchy)this._head.remove(action) : null;
        if (hier != null) {
            hier = null;
            return true;
        }
        if (jtsLogger.logger.isDebugEnabled() && jtsLogger.loggerI18N.isWarnEnabled()) {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.interposition.resources.arjuna.ipfail", new Object[]{"Interposition.removeHeirarchy", action});
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void compareHierarchies(PropagationContext ctx, InterposedHierarchy ih) {
        LogNoi18n child;
        int depth = ctx.parents.length;
        Uid[] ctxHierarchy = new Uid[depth + 1];
        boolean printHierarchies = false;
        for (int i = depth - 1; i >= 0; --i) {
            ctxHierarchy[i + 1] = new Uid(Utility.otidToUid(ctx.parents[i].otid));
        }
        ctxHierarchy[0] = new Uid(Utility.otidToUid(ctx.current.otid));
        ServerTopLevelAction action = ih.action();
        boolean problem = false;
        if (action != null) {
            if (action.get_uid().notEquals(ctxHierarchy[depth])) {
                if (jtsLogger.loggerI18N.isWarnEnabled()) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.interposition.resources.arjuna.iptl", new Object[]{action.get_uid(), ctxHierarchy[depth - 1]});
                }
                printHierarchies = true;
            } else {
                if (depth > 0) {
                    child = action.getChild(ctxHierarchy[depth - 1]);
                    if (child != null) {
                        int i = 0;
                        for (i = depth - 2; i >= 0 && child != null; --i) {
                            if ((child = child.getChild(ctxHierarchy[i])) != null) continue;
                            problem = true;
                            break;
                        }
                        if (i != -1) {
                            problem = true;
                        }
                    } else {
                        problem = true;
                    }
                }
                if (problem) {
                    if (jtsLogger.loggerI18N.isWarnEnabled()) {
                        jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.interposition.resources.arjuna.ipnt");
                    }
                    printHierarchies = true;
                }
            }
        } else {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.interposition.resources.arjuna.ipnull");
            }
            printHierarchies = true;
        }
        if (!printHierarchies) {
            printHierarchies = jtsLogger.logger.isDebugEnabled();
        }
        if (printHierarchies) {
            child = jtsLogger.logger;
            synchronized (child) {
                if (!problem) {
                    if (jtsLogger.logger.isDebugEnabled()) {
                        jtsLogger.logger.debug(16L, 4L, 256L, Utility.getHierarchy(ctx));
                    }
                    if (jtsLogger.logger.isDebugEnabled()) {
                        jtsLogger.logger.debug(16L, 4L, 256L, ih.hierarchy());
                    }
                } else {
                    if (jtsLogger.logger.isWarnEnabled()) {
                        jtsLogger.logger.warn(Utility.getHierarchy(ctx));
                    }
                    if (jtsLogger.logger.isWarnEnabled()) {
                        jtsLogger.logger.warn(ih.hierarchy());
                    }
                }
            }
        }
        if (ctxHierarchy != null) {
            for (int i = 0; i < depth; ++i) {
                if (ctxHierarchy[i] == null) continue;
                ctxHierarchy[i] = null;
            }
            ctxHierarchy = null;
        }
    }
}

