/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.interposition.resources.arjuna;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.arjuna.template.HashList;
import com.arjuna.ats.internal.arjuna.template.HashListIterator;
import com.arjuna.ats.internal.arjuna.template.ListElement;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.orbspecific.interposition.ServerControl;
import com.arjuna.ats.internal.jts.orbspecific.interposition.resources.arjuna.ServerNestedAction;
import com.arjuna.ats.jts.logging.jtsLogger;
import org.omg.CORBA.Object;
import org.omg.CosTransactions.Status;

public class ServerResource
implements ListElement {
    protected ServerControl _theControl;
    protected HashList _children;
    protected Uid _theUid;
    protected ServerResource _parent;
    protected boolean _valid;
    protected boolean _destroyed;

    public void finalize() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(2L, 4L, 256L, "ServerResource.finalize ( " + this._theUid + " )");
        }
        this.tidyup();
    }

    public boolean interposeResource() {
        return true;
    }

    public final boolean valid() {
        return this._valid;
    }

    public final synchronized boolean destroyed() {
        return this._destroyed;
    }

    public final ServerControl control() {
        return this._theControl;
    }

    public final boolean addChild(ServerNestedAction c) {
        if (this._children != null && this._children.add((ListElement)c)) {
            c.setParentHandle(this);
            return true;
        }
        return false;
    }

    public final boolean removeChild(ServerNestedAction c) {
        if (this._children != null) {
            c.setParentHandle(null);
            return this._children.remove((ListElement)c);
        }
        return false;
    }

    public final ServerNestedAction getChild(Uid id) {
        if (this._children != null) {
            return (ServerNestedAction)this._children.lookFor(id);
        }
        return null;
    }

    public final HashList getChildren() {
        return this._children;
    }

    public final boolean abortChild(ServerNestedAction toAbort) {
        if (this._children != null && toAbort != null) {
            ServerNestedAction child = (ServerNestedAction)this._children.remove(toAbort.get_uid());
            if (child != null) {
                Status nestedStatus = child.otsStatus();
                if (nestedStatus != Status.StatusRolledBack && nestedStatus != Status.StatusCommitted && nestedStatus != Status.StatusNoTransaction) {
                    child.rollback_subtransaction();
                }
                try {
                    ORBManager.getPOA().shutdownObject((Object)child.theResource());
                }
                catch (Exception e) {
                    // empty catch block
                }
                return true;
            }
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.interposition.resources.arjuna.notchild", new java.lang.Object[]{"ServerResource.abortChild"});
            }
        } else if (jtsLogger.loggerI18N.isWarnEnabled()) {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.interposition.resources.arjuna.nochild", new java.lang.Object[]{"ServerResource.abortChild"});
        }
        return false;
    }

    public final synchronized void setParentHandle(ServerResource p) {
        this._parent = p;
    }

    public final synchronized ServerResource getParentHandle() {
        return this._parent;
    }

    public Uid get_uid() {
        return this._theUid;
    }

    public final Status otsStatus() {
        try {
            if (this._theControl != null) {
                return this._theControl.getImplHandle().get_status();
            }
            return Status.StatusNoTransaction;
        }
        catch (Exception e) {
            return Status.StatusUnknown;
        }
    }

    public final String getChildren(int depth) {
        String children = "";
        if (this._children != null) {
            HashListIterator iter = new HashListIterator(this._children);
            ServerNestedAction childPtr = (ServerNestedAction)iter.iterate();
            while (childPtr != null) {
                children = children + "\n";
                for (int i = 0; i < depth; ++i) {
                    children = children + " ";
                }
                children = children + childPtr.get_uid();
                children = children + childPtr.getChildren(depth + 1);
                childPtr = (ServerNestedAction)iter.iterate();
            }
        }
        return children;
    }

    protected ServerResource() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(1L, 2L, 256L, "ServerResource::ServerResource ()");
        }
        this._theControl = null;
        this._children = null;
        this._parent = null;
        this._valid = true;
        this._destroyed = false;
    }

    protected ServerResource(ServerControl control) {
        this._theControl = control;
        this._children = new HashList(11);
        this._theUid = control.get_uid();
        this._parent = null;
        this._valid = true;
        this._destroyed = false;
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(1L, 2L, 256L, "ServerResource::ServerResource ( " + this._theUid + " )");
        }
    }

    protected void tidyup() {
        if (this._children != null) {
            ServerNestedAction ptr = (ServerNestedAction)this._children.orderedPop();
            while (ptr != null) {
                ptr.setParentHandle(null);
                try {
                    ORBManager.getPOA().shutdownObject((Object)ptr.theResource());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ptr = (ServerNestedAction)this._children.orderedPop();
            }
            this._children = null;
        }
        if (this._theControl != null) {
            if (this._theControl.isWrapper()) {
                try {
                    this._theControl.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._theControl = null;
        }
    }
}

