/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.packagemanager.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import org.jboss.ejb3.packagemanager.PackageManager;
import org.jboss.ejb3.packagemanager.PackageManagerEnvironment;
import org.jboss.ejb3.packagemanager.annotation.TransactionAttribute;
import org.jboss.ejb3.packagemanager.annotation.TransactionAttributeType;
import org.jboss.ejb3.packagemanager.exception.PackageManagerException;
import org.jboss.ejb3.packagemanager.exception.PackageNotInstalledException;
import org.jboss.ejb3.packagemanager.impl.DefaultPackageManagerImpl;
import org.jboss.ejb3.packagemanager.option.InstallOptions;
import org.jboss.ejb3.packagemanager.option.UnInstallOptions;
import org.jboss.ejb3.packagemanager.option.UpgradeOptions;
import org.jboss.ejb3.packagemanager.proxy.TransactionalPackageManagerInvocationHandler;
import org.jboss.ejb3.packagemanager.tx.TransactionManagerImpl;
import org.jboss.logging.Logger;

public class TransactionalPackageManager
extends DefaultPackageManagerImpl
implements Synchronization {
    private static Logger logger = Logger.getLogger(TransactionalPackageManager.class);
    private TransactionManager txManager = TransactionManagerImpl.getInstance();

    public static PackageManager createNewInstance(PackageManagerEnvironment environment, String jbossHome) {
        TransactionalPackageManager packageManager = new TransactionalPackageManager(environment, jbossHome);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        TransactionalPackageManagerInvocationHandler invocationHandler = new TransactionalPackageManagerInvocationHandler(packageManager);
        return (PackageManager)Proxy.newProxyInstance(cl, new Class[]{PackageManager.class}, (InvocationHandler)invocationHandler);
    }

    protected TransactionalPackageManager(PackageManagerEnvironment environment, String jbossHome) {
        super(environment, jbossHome);
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.txManager;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void installPackage(String pkgPath) throws PackageManagerException {
        super.installPackage(pkgPath);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void installPackage(URL packageURL) throws PackageManagerException {
        super.installPackage(packageURL);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void installPackage(String pkgPath, InstallOptions installOptions) throws PackageManagerException {
        super.installPackage(pkgPath, installOptions);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void installPackage(URL packageURL, InstallOptions installOptions) throws PackageManagerException {
        super.installPackage(packageURL, installOptions);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void updatePackage(String packageFilePath) throws PackageManagerException {
        super.updatePackage(packageFilePath);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void updatePackage(String packageFilePath, UpgradeOptions upgradeOptions) throws PackageManagerException {
        super.updatePackage(packageFilePath, upgradeOptions);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void updatePackage(URL packageURL) throws PackageManagerException {
        super.updatePackage(packageURL);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void updatePackage(URL packageURL, UpgradeOptions upgradeOptions) throws PackageManagerException {
        super.updatePackage(packageURL, upgradeOptions);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void removePackage(String packageName) throws PackageNotInstalledException, PackageManagerException {
        super.removePackage(packageName);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void removePackage(String packageName, UnInstallOptions uninstallOptions) throws PackageNotInstalledException, PackageManagerException {
        super.removePackage(packageName, uninstallOptions);
    }

    public void afterCompletion(int status) {
        if (this.getDatabaseManager() instanceof Synchronization) {
            Synchronization dbManager = (Synchronization)this.getDatabaseManager();
            dbManager.afterCompletion(status);
        }
    }

    public void beforeCompletion() {
        if (this.getDatabaseManager() instanceof Synchronization) {
            Synchronization dbManager = (Synchronization)this.getDatabaseManager();
            dbManager.beforeCompletion();
        }
    }
}

