/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.packagemanager.main;

import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.jboss.ejb3.packagemanager.PackageManagerEnvironment;
import org.jboss.ejb3.packagemanager.exception.PackageManagerException;
import org.jboss.ejb3.packagemanager.util.DBUtil;
import org.jboss.logging.Logger;

public class Setup {
    private static Logger logger = Logger.getLogger(Setup.class);

    public static void main(String[] args) throws PackageManagerException {
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option schemaFileCmdOption = cmdLineParser.addStringOption('f', "file");
        CmdLineParser.Option packageManagerHomeCmdOption = cmdLineParser.addStringOption('p', "pmhome");
        try {
            cmdLineParser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println("Error parsing command " + e.getMessage());
            Setup.printUsage();
            throw new PackageManagerException(e.getMessage());
        }
        String packageManagerHome = (String)cmdLineParser.getOptionValue(packageManagerHomeCmdOption);
        if (packageManagerHome == null) {
            throw new PackageManagerException("Package manager home has not been set");
        }
        File pmHome = new File(packageManagerHome);
        if (!pmHome.exists()) {
            throw new PackageManagerException("Package manager home " + pmHome + " does not exist!");
        }
        logger.info((Object)("Using Package Manager Home: " + packageManagerHome));
        PackageManagerEnvironment env = new PackageManagerEnvironment(packageManagerHome);
        String schemaSetupScript = (String)cmdLineParser.getOptionValue(schemaFileCmdOption);
        if (schemaSetupScript != null) {
            File schemaFile = new File(schemaSetupScript);
            if (!schemaFile.exists()) {
                throw new PackageManagerException("Could not setup the database for package manager, because of non-existent schema file " + schemaSetupScript);
            }
            Connection conn = null;
            File dbHome = env.getDataDir();
            System.setProperty("derby.system.home", dbHome.getAbsolutePath());
            logger.info((Object)("Package manager DB home set to " + System.getProperty("derby.system.home")));
            try {
                conn = DriverManager.getConnection("jdbc:derby:pmdb;create=true");
                DBUtil.runSql(conn, schemaFile);
                logger.info((Object)"Successfully setup the package manager database");
            }
            catch (SQLException sqle) {
                throw new PackageManagerException("Could not setup package manager database: ", sqle);
            }
            catch (IOException ioe) {
                throw new PackageManagerException("Could not setup package manager database: ", ioe);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sqle) {
                        logger.trace((Object)"Could not close connection:", (Throwable)sqle);
                    }
                }
            }
        }
    }

    private static void printUsage() {
        System.out.println("Usage: setup [-f path_to_schema_file]");
    }
}

