/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.packagemanager.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.ejb3.packagemanager.PackageManager;
import org.jboss.ejb3.packagemanager.annotation.TransactionAttribute;
import org.jboss.ejb3.packagemanager.annotation.TransactionAttributeType;
import org.jboss.logging.Logger;

public class TransactionalPackageManagerInvocationHandler
implements InvocationHandler {
    private PackageManager packageManager;
    private static Logger logger = Logger.getLogger(TransactionalPackageManagerInvocationHandler.class);

    public TransactionalPackageManagerInvocationHandler(PackageManager packageManager) {
        this.packageManager = packageManager;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        TransactionAttribute txAnnotation = this.getTxAttribute(method);
        if (txAnnotation == null) {
            return method.invoke((Object)this.packageManager, args);
        }
        TransactionAttributeType txType = txAnnotation.value();
        switch (txType) {
            case REQUIRED: {
                return this.invokeInCurrentTx(proxy, method, args);
            }
            case REQUIRES_NEW: {
                return this.invokeInNewTx(proxy, method, args);
            }
        }
        throw new RuntimeException("Unknow tx type " + (Object)((Object)txType));
    }

    private Object invokeInCurrentTx(Object proxy, Method method, Object[] args) throws Throwable {
        TransactionManager txManager = this.packageManager.getTransactionManager();
        Transaction currentTx = txManager.getTransaction();
        boolean txInitiator = false;
        if (currentTx == null) {
            txManager.begin();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Started tx " + txManager.getTransaction() + " for method " + method));
            }
            currentTx = txManager.getTransaction();
            this.registerForSynchronization(txManager.getTransaction());
            txInitiator = true;
        }
        try {
            Object result = method.invoke((Object)this.packageManager, args);
            if (txInitiator) {
                if (txManager.getStatus() == 1) {
                    txManager.rollback();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Rolled back tx " + txManager.getTransaction() + " for method " + method));
                    }
                } else {
                    txManager.commit();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Committed tx for method " + method));
                    }
                }
            }
            return result;
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (!txInitiator) {
                txManager.setRollbackOnly();
            } else {
                txManager.rollback();
            }
            throw cause;
        }
    }

    private Object invokeInNewTx(Object proxy, Method method, Object[] args) throws Throwable {
        TransactionManager txManager = this.packageManager.getTransactionManager();
        Transaction currentTx = txManager.getTransaction();
        try {
            if (currentTx != null) {
                txManager.suspend();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Suspended tx " + txManager.getTransaction() + " for method " + method));
                }
            }
            txManager.begin();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Started tx " + txManager.getTransaction() + " for method " + method));
            }
            Transaction newTx = txManager.getTransaction();
            this.registerForSynchronization(newTx);
            try {
                Object result = method.invoke((Object)this.packageManager, args);
                if (newTx.getStatus() == 1) {
                    newTx.rollback();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Rolled back tx " + txManager.getTransaction() + " for method " + method));
                    }
                } else {
                    newTx.commit();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Committed tx " + txManager.getTransaction() + " for method " + method));
                    }
                }
                Object object = result;
                return object;
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                newTx.rollback();
                throw cause;
            }
        }
        finally {
            if (currentTx != null) {
                txManager.resume(currentTx);
            }
        }
    }

    private TransactionAttribute getTxAttribute(Method method) throws SecurityException, NoSuchMethodException {
        Method methodOnPackageManagerImpl = this.packageManager.getClass().getMethod(method.getName(), method.getParameterTypes());
        return methodOnPackageManagerImpl.getAnnotation(TransactionAttribute.class);
    }

    private void registerForSynchronization(Transaction tx) throws IllegalStateException, RollbackException, SystemException {
        if (this.packageManager instanceof Synchronization) {
            tx.registerSynchronization((Synchronization)this.packageManager);
        }
    }
}

