/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.packagemanager.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.jboss.logging.Logger;

public class DBUtil {
    private static Logger logger = Logger.getLogger(DBUtil.class);

    public static void runSql(Connection conn, File sqlFile) throws IOException, SQLException {
        logger.debug((Object)("SQL being run from file " + sqlFile));
        FileInputStream sql = new FileInputStream(sqlFile);
        DBUtil.runSql(conn, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runSql(Connection conn, InputStream sql) throws IOException, SQLException {
        InputStreamReader reader = new InputStreamReader(sql);
        BufferedReader bufferedReader = new BufferedReader(reader);
        long lineNo = 0L;
        Statement statement = conn.createStatement();
        try {
            StringBuffer trimmedSql = new StringBuffer();
            String line = bufferedReader.readLine();
            while (line != null) {
                try {
                    ++lineNo;
                    line = line.trim();
                    if (!(line.length() == 0 || line.startsWith("--") || line.startsWith("//") || line.startsWith("/*"))) {
                        trimmedSql.append(" ");
                        trimmedSql.append(line);
                        if (trimmedSql.toString().endsWith(";")) {
                            String sqlToRun = trimmedSql.substring(0, trimmedSql.length() - 1);
                            logger.debug((Object)sqlToRun);
                            statement.execute(sqlToRun);
                            trimmedSql = new StringBuffer();
                        }
                    }
                }
                catch (SQLException sqle) {
                    logger.error((Object)("SQLException at line number " + lineNo), (Throwable)sqle);
                    throw sqle;
                }
                line = bufferedReader.readLine();
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }
}

