/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.packagemanager.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class IOUtil {
    public static void copy(File src, File dest) throws IOException {
        FileInputStream fis = new FileInputStream(src);
        FileOutputStream fos = new FileOutputStream(dest);
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = fis.read(buffer))) {
            fos.write(buffer, 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractJarFile(File destDir, JarFile jar) throws IOException {
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        Enumeration<JarEntry> jarEntries = jar.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry entry = jarEntries.nextElement();
            File destFile = new File(destDir, entry.getName());
            if (entry.isDirectory()) {
                destFile.mkdirs();
                continue;
            }
            File parentDir = destFile.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            InputStream is = null;
            FileOutputStream fos = null;
            try {
                is = jar.getInputStream(entry);
                fos = new FileOutputStream(destFile);
                while (is.available() > 0) {
                    fos.write(is.read());
                }
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
                if (is == null) continue;
                is.close();
            }
        }
    }
}

