/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.installer.manifest;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestEditor {
    private static final String ENTRY_NAME_CLASS_PATH = "Class-Path";
    private static final String DELIMITER_CLASS_PATH_ENTRIES = " ";
    private Manifest manifest;

    public ManifestEditor(JarFile jar) {
        assert (jar != null) : "JAR must be specified";
        Manifest manifest = null;
        try {
            manifest = jar.getManifest();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get manifest from JAR: " + jar, e);
        }
        if (manifest == null) {
            ManifestEditor.getPrintStream().println("Created new empty manifest for JAR: " + jar);
            manifest = new Manifest();
        }
        this.setManifest(manifest);
    }

    public void addEntriesToClassPath(Set<String> entriesToAdd) {
        String[] classPathEntries;
        Manifest manifest = this.getManifest();
        String classPath = manifest.getMainAttributes().getValue(ENTRY_NAME_CLASS_PATH);
        for (String classPathEntry : classPathEntries = classPath == null ? new String[]{} : classPath.trim().split(DELIMITER_CLASS_PATH_ENTRIES)) {
            entriesToAdd.add(classPathEntry);
        }
        String newCp = this.flattenClassPathEntries(entriesToAdd);
        ManifestEditor.getPrintStream().println("Setting the Class-Path to: " + newCp);
        manifest.getMainAttributes().putValue(ENTRY_NAME_CLASS_PATH, newCp);
    }

    public void removeEntriesFromClassPath(Set<String> entriesToRemove) {
        Manifest manifest = this.getManifest();
        String classPath = manifest.getMainAttributes().getValue(ENTRY_NAME_CLASS_PATH);
        if (classPath == null || classPath.length() == 0) {
            return;
        }
        String[] classPathEntries = classPath.trim().split(DELIMITER_CLASS_PATH_ENTRIES);
        ArrayList<String> newClassPathEntries = new ArrayList<String>();
        for (String classPathEntry : classPathEntries) {
            if (!entriesToRemove.contains(classPathEntry)) {
                newClassPathEntries.add(classPathEntry);
                continue;
            }
            ManifestEditor.getPrintStream().println("Removing from Class-Path: " + classPathEntry);
        }
        String newCp = this.flattenClassPathEntries(newClassPathEntries);
        ManifestEditor.getPrintStream().println("Setting the Class-Path to: " + newCp);
        manifest.getMainAttributes().putValue(ENTRY_NAME_CLASS_PATH, newCp);
    }

    private String flattenClassPathEntries(Collection<String> classPathEntries) {
        StringBuffer sb = new StringBuffer();
        for (String newEntry : classPathEntries) {
            sb.append(newEntry.trim());
            sb.append(DELIMITER_CLASS_PATH_ENTRIES);
        }
        String newCp = sb.toString().trim();
        return newCp;
    }

    private static PrintStream getPrintStream() {
        return System.out;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    private void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }
}

