/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.jndiregistrar;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.common.registrar.spi.DuplicateBindException;
import org.jboss.ejb3.common.registrar.spi.Ejb3RegistrarLocator;
import org.jboss.ejb3.common.string.StringUtils;
import org.jboss.ejb3.proxy.factory.ProxyFactory;
import org.jboss.ejb3.proxy.factory.session.SessionProxyFactory;
import org.jboss.ejb3.proxy.jndiregistrar.JndiReferenceBinding;
import org.jboss.ejb3.proxy.jndiregistrar.JndiReferenceBindingSet;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.RemoteBindingMetaData;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.JbossSessionBeanJndiNameResolver;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.naming.Util;
import org.jboss.remoting.InvokerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JndiSessionRegistrarBase {
    private static final Logger log = Logger.getLogger(JndiSessionRegistrarBase.class);
    private static final String KEY_PREFIX_PROXY_FACTORY_REGISTRY = "ProxyFactory/";
    private static final String OBJECT_FACTORY_CLASSNAME_PREFIX = "Proxy for: ";
    public static final String DEFAULT_CLIENT_BINDING;
    private String sessionProxyObjectFactoryType;

    public JndiSessionRegistrarBase(String sessionProxyObjectFactoryType) {
        assert (sessionProxyObjectFactoryType != null && !sessionProxyObjectFactoryType.equals("")) : "Session EJB Proxy " + ObjectFactory.class.getSimpleName() + " must be specified.";
        try {
            Class.forName(sessionProxyObjectFactoryType);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Specified " + ObjectFactory.class.getSimpleName() + " of " + sessionProxyObjectFactoryType + " could not be loaded.", e);
        }
        this.setSessionProxyObjectFactoryType(sessionProxyObjectFactoryType);
        log.debug((Object)("Using Session EJB JNDI " + ObjectFactory.class.getSimpleName() + ": " + this.getSessionProxyObjectFactoryType()));
    }

    public void bindEjb(Context context, JBossSessionBeanMetaData smd, ClassLoader cl, String containerName, String containerGuid, Advisor advisor) {
        JndiReferenceBindingSet bindingSet = this.createJndiReferenceBindingSet(context, smd, cl, containerName, containerGuid, advisor);
        this.bind(context, bindingSet, false, true);
    }

    protected JndiReferenceBindingSet createJndiReferenceBindingSet(Context context, JBossSessionBeanMetaData smd, ClassLoader cl, String containerName, String containerGuid, Advisor advisor) {
        String ejbName = smd.getEjbName();
        log.debug((Object)("Found Session Bean: " + ejbName));
        BusinessLocalsMetaData businessLocals = smd.getBusinessLocals();
        BusinessRemotesMetaData businessRemotes = smd.getBusinessRemotes();
        String localHome = StringUtils.adjustWhitespaceStringToNull((String)smd.getLocalHome());
        String remoteHome = StringUtils.adjustWhitespaceStringToNull((String)smd.getHome());
        boolean hasLocalView = localHome != null || businessLocals != null && businessLocals.size() > 0;
        boolean hasRemoteView = remoteHome != null || businessRemotes != null && businessRemotes.size() > 0;
        JndiReferenceBindingSet bindingSet = new JndiReferenceBindingSet(context);
        if (hasRemoteView) {
            boolean bindRemoteAndHomeTogether;
            StringRefAddr refAddr;
            List bindings = smd.getRemoteBindings();
            assert (bindings != null && bindings.size() > 0) : "Remote Bindings are required and none are present";
            RemoteBindingMetaData remoteBinding = (RemoteBindingMetaData)bindings.get(0);
            String url = remoteBinding.getClientBindUrl();
            if (url == null || url.trim().equals("")) {
                url = DEFAULT_CLIENT_BINDING;
                remoteBinding.setClientBindUrl(url);
            }
            String remoteProxyFactoryKey = this.getProxyFactoryRegistryKey(smd, false);
            SessionProxyFactory factory = this.createRemoteProxyFactory(remoteProxyFactoryKey, containerName, containerGuid, smd, cl, url, advisor);
            this.registerProxyFactory(remoteProxyFactoryKey, factory, (JBossEnterpriseBeanMetaData)smd);
            ArrayList<RefAddr> refAddrsForDefaultRemote = new ArrayList<RefAddr>();
            if (businessRemotes != null) {
                for (String businessRemote : businessRemotes) {
                    refAddr = new StringRefAddr("Remote Business Interface", businessRemote);
                    refAddrsForDefaultRemote.add(refAddr);
                }
            }
            if (bindRemoteAndHomeTogether = this.isHomeAndBusinessBoundTogether(smd, false)) {
                String home = smd.getHome();
                assert (home != null) : "Home and Business set to be bound together, yet no home is defined";
                refAddr = new StringRefAddr("EJB 2.x Remote Home Interface", home);
                refAddrsForDefaultRemote.add(refAddr);
            } else if (smd.getHome() != null && !smd.getHome().equals("")) {
                String homeType = smd.getHome();
                StringRefAddr refAddrHomeInterface = new StringRefAddr("EJB 2.x Remote Home Interface", homeType);
                RefAddr refAddrRemoting = this.createRemotingRefAddr(smd);
                Reference homeRef = this.createStandardReference(OBJECT_FACTORY_CLASSNAME_PREFIX + homeType, remoteProxyFactoryKey, containerName);
                homeRef.add(refAddrHomeInterface);
                homeRef.add(refAddrRemoting);
                String homeAddress = smd.getHomeJndiName();
                assert (homeAddress != null && !homeAddress.equals("")) : "JNDI Address for Remote Home must be defined";
                log.debug((Object)("Remote Home View for EJB " + smd.getEjbName() + " to be bound into JNDI at \"" + homeAddress + "\""));
                bindingSet.addHomeRemoteBinding(new JndiReferenceBinding(homeAddress, homeRef));
            }
            refAddrsForDefaultRemote.add(this.createRemotingRefAddr(smd));
            String defaultRemoteClassName = this.getHumanReadableListOfInterfacesInRefAddrs(refAddrsForDefaultRemote);
            Reference defaultRemoteRef = this.createStandardReference(OBJECT_FACTORY_CLASSNAME_PREFIX + defaultRemoteClassName, remoteProxyFactoryKey, containerName);
            for (RefAddr refAddr2 : refAddrsForDefaultRemote) {
                log.debug((Object)("Adding " + RefAddr.class.getSimpleName() + " to Default Remote " + Reference.class.getSimpleName() + ": Type \"" + refAddr2.getType() + "\", Content \"" + refAddr2.getContent() + "\""));
                defaultRemoteRef.add(refAddr2);
            }
            String defaultRemoteAddress = smd.getJndiName();
            log.debug((Object)("Default Remote Business View for EJB " + smd.getEjbName() + " to be bound into JNDI at \"" + defaultRemoteAddress + "\""));
            bindingSet.addDefaultRemoteBinding(new JndiReferenceBinding(defaultRemoteAddress, defaultRemoteRef));
            if (businessRemotes != null) {
                for (String businessRemote : businessRemotes) {
                    StringRefAddr refAddrBusinessInterface = new StringRefAddr("Remote Business Interface", businessRemote);
                    RefAddr refAddrRemoting = this.createRemotingRefAddr(smd);
                    Reference ref = this.createStandardReference(OBJECT_FACTORY_CLASSNAME_PREFIX + businessRemote, remoteProxyFactoryKey, containerName);
                    ref.add(refAddrBusinessInterface);
                    ref.add(refAddrRemoting);
                    String address = JbossSessionBeanJndiNameResolver.resolveJndiName((JBossEnterpriseBeanMetaData)smd, (String)businessRemote);
                    log.debug((Object)("Remote Business View for " + businessRemote + " of EJB " + smd.getEjbName() + " to be bound into JNDI at \"" + address + "\""));
                    bindingSet.addBusinessRemoteBinding(businessRemote, new JndiReferenceBinding(address, ref));
                }
            }
        }
        if (hasLocalView) {
            boolean bindLocalAndLocalHomeTogether;
            StringRefAddr refAddr;
            String localProxyFactoryKey = this.getProxyFactoryRegistryKey(smd, true);
            SessionProxyFactory factory = this.createLocalProxyFactory(localProxyFactoryKey, containerName, containerGuid, smd, cl, advisor);
            this.registerProxyFactory(localProxyFactoryKey, factory, (JBossEnterpriseBeanMetaData)smd);
            ArrayList<RefAddr> refAddrsForDefaultLocal = new ArrayList<RefAddr>();
            if (businessLocals != null) {
                for (String businessLocal : businessLocals) {
                    refAddr = new StringRefAddr("Local Business Interface", businessLocal);
                    refAddrsForDefaultLocal.add(refAddr);
                }
            }
            if (bindLocalAndLocalHomeTogether = this.isHomeAndBusinessBoundTogether(smd, true)) {
                StringRefAddr refAddr3 = new StringRefAddr("EJB 2.x Local Home Interface", smd.getLocalHome());
                refAddrsForDefaultLocal.add(refAddr3);
            } else if (smd.getLocalHome() != null && !smd.getLocalHome().equals("")) {
                String localHomeType = smd.getLocalHome();
                refAddr = new StringRefAddr("EJB 2.x Local Home Interface", localHomeType);
                Reference localHomeRef = this.createStandardReference(OBJECT_FACTORY_CLASSNAME_PREFIX + localHomeType, localProxyFactoryKey, containerName);
                localHomeRef.add(refAddr);
                String localHomeAddress = smd.getLocalHomeJndiName();
                log.debug((Object)("Local Home View for EJB " + smd.getEjbName() + " to be bound into JNDI at \"" + localHomeAddress + "\""));
                bindingSet.addHomeLocalBinding(new JndiReferenceBinding(localHomeAddress, localHomeRef));
            }
            String defaultLocalClassName = this.getHumanReadableListOfInterfacesInRefAddrs(refAddrsForDefaultLocal);
            Reference defaultLocalRef = this.createStandardReference(OBJECT_FACTORY_CLASSNAME_PREFIX + defaultLocalClassName, localProxyFactoryKey, containerName);
            for (RefAddr refAddr4 : refAddrsForDefaultLocal) {
                log.debug((Object)("Adding " + RefAddr.class.getSimpleName() + " to Default Local " + Reference.class.getSimpleName() + ": Type \"" + refAddr4.getType() + "\", Content \"" + refAddr4.getContent() + "\""));
                defaultLocalRef.add(refAddr4);
            }
            String defaultLocalAddress = smd.getLocalJndiName();
            log.debug((Object)("Default Local Business View for EJB " + smd.getEjbName() + " to be bound into JNDI at \"" + defaultLocalAddress + "\""));
            bindingSet.addDefaultLocalBinding(new JndiReferenceBinding(defaultLocalAddress, defaultLocalRef));
            if (businessLocals != null) {
                for (String businessLocal : businessLocals) {
                    StringRefAddr refAddr5 = new StringRefAddr("Local Business Interface", businessLocal);
                    Reference ref = this.createStandardReference(OBJECT_FACTORY_CLASSNAME_PREFIX + businessLocal, localProxyFactoryKey, containerName);
                    ref.add(refAddr5);
                    String address = JbossSessionBeanJndiNameResolver.resolveJndiName((JBossEnterpriseBeanMetaData)smd, (String)businessLocal);
                    log.debug((Object)("Local Business View for " + businessLocal + " of EJB " + smd.getEjbName() + " to be bound into JNDI at \"" + address + "\""));
                    bindingSet.addBusinessLocalBinding(businessLocal, new JndiReferenceBinding(address, ref));
                }
            }
        }
        return bindingSet;
    }

    public void unbindEjb(Context context, JBossSessionBeanMetaData smd) {
        boolean hasRemoteView;
        String ejbName = smd.getEjbName();
        log.debug((Object)("Unbinding JNDI References for Session Bean: " + ejbName));
        BusinessLocalsMetaData businessLocals = smd.getBusinessLocals();
        BusinessRemotesMetaData businessRemotes = smd.getBusinessRemotes();
        String localHome = StringUtils.adjustWhitespaceStringToNull((String)smd.getLocalHome());
        String remoteHome = StringUtils.adjustWhitespaceStringToNull((String)smd.getHome());
        boolean hasLocalView = localHome != null || businessLocals != null && businessLocals.size() > 0;
        boolean bl = hasRemoteView = remoteHome != null || businessRemotes != null && businessRemotes.size() > 0;
        if (hasRemoteView) {
            List bindings = smd.getRemoteBindings();
            assert (bindings != null && bindings.size() > 0) : "Remote Bindings are required and none are present";
            String remoteProxyFactoryKey = this.getProxyFactoryRegistryKey(smd, false);
            this.deregisterProxyFactory(remoteProxyFactoryKey);
            boolean bindRemoteAndHomeTogether = this.isHomeAndBusinessBoundTogether(smd, false);
            if (smd.getHome() != null && !smd.getHome().equals("") && !bindRemoteAndHomeTogether) {
                String homeAddress = smd.getHomeJndiName();
                log.debug((Object)("Remote Home View for EJB " + smd.getEjbName() + " to be unbound from JNDI at \"" + homeAddress + "\""));
                this.unbind(context, homeAddress);
            }
            String defaultRemoteAddress = smd.getJndiName();
            log.debug((Object)("Default Remote Business View for EJB " + smd.getEjbName() + " to be unbound from JNDI at \"" + defaultRemoteAddress + "\""));
            this.unbind(context, defaultRemoteAddress);
            if (businessRemotes != null) {
                for (String businessRemote : businessRemotes) {
                    String address = JbossSessionBeanJndiNameResolver.resolveJndiName((JBossEnterpriseBeanMetaData)smd, (String)businessRemote);
                    log.debug((Object)("Remote Business View for " + businessRemote + " of EJB " + smd.getEjbName() + " to be unbound from JNDI at \"" + address + "\""));
                    this.unbind(context, address);
                }
            }
        }
        if (hasLocalView) {
            String localProxyFactoryKey = this.getProxyFactoryRegistryKey(smd, true);
            this.deregisterProxyFactory(localProxyFactoryKey);
            boolean bindLocalAndLocalHomeTogether = this.isHomeAndBusinessBoundTogether(smd, true);
            if (smd.getLocalHome() != null && !smd.getLocalHome().equals("") && !bindLocalAndLocalHomeTogether) {
                String localHomeAddress = smd.getLocalHomeJndiName();
                log.debug((Object)("Local Home View for EJB " + smd.getEjbName() + " to be unbound from JNDI at \"" + localHomeAddress + "\""));
                this.unbind(context, localHomeAddress);
            }
            String defaultLocalAddress = smd.getLocalJndiName();
            log.debug((Object)("Default Local Business View for EJB " + smd.getEjbName() + " to be unbound from JNDI at \"" + defaultLocalAddress + "\""));
            this.unbind(context, defaultLocalAddress);
            if (businessLocals != null) {
                for (String businessLocal : businessLocals) {
                    String address = JbossSessionBeanJndiNameResolver.resolveJndiName((JBossEnterpriseBeanMetaData)smd, (String)businessLocal);
                    log.debug((Object)("Local Business View for " + businessLocal + " of EJB " + smd.getEjbName() + " to be unbound from JNDI at \"" + address + "\""));
                    this.unbind(context, address);
                }
            }
        }
    }

    protected abstract SessionProxyFactory createLocalProxyFactory(String var1, String var2, String var3, JBossSessionBeanMetaData var4, ClassLoader var5, Advisor var6);

    protected abstract SessionProxyFactory createRemoteProxyFactory(String var1, String var2, String var3, JBossSessionBeanMetaData var4, ClassLoader var5, String var6, Advisor var7);

    protected Reference createStandardReference(String referenceName, String proxyFactoryRegistryKey, String containerName) {
        Reference ref = new Reference(referenceName, this.getSessionProxyObjectFactoryType(), null);
        assert (proxyFactoryRegistryKey != null && !proxyFactoryRegistryKey.trim().equals("")) : "Proxy Factory Registry key is required but not supplied";
        String proxyFactoryRefType = "ProxyFactoryKey";
        StringRefAddr proxyFactoryRefAddr = new StringRefAddr(proxyFactoryRefType, proxyFactoryRegistryKey);
        ref.add(proxyFactoryRefAddr);
        log.debug((Object)("Adding " + RefAddr.class.getSimpleName() + " to " + Reference.class.getSimpleName() + ": Type \"" + proxyFactoryRefType + "\", Content \"" + proxyFactoryRegistryKey + "\""));
        assert (containerName != null && !containerName.trim().equals("")) : "Container Name is required but not supplied";
        String ejbContainerRefType = "EJB Container Name";
        StringRefAddr containerRefAddr = new StringRefAddr(ejbContainerRefType, containerName);
        ref.add(containerRefAddr);
        log.debug((Object)("Adding " + RefAddr.class.getSimpleName() + " to " + Reference.class.getSimpleName() + ": Type \"" + ejbContainerRefType + "\", Content \"" + containerName + "\""));
        return ref;
    }

    protected void bind(Context context, JndiReferenceBindingSet bindings, boolean useRebind, boolean bindLocals) {
        for (JndiReferenceBinding jndiReferenceBinding : bindings.getDefaultRemoteBindings()) {
            this.bind(context, jndiReferenceBinding, useRebind);
        }
        for (JndiReferenceBinding jndiReferenceBinding : bindings.getHomeRemoteBindings()) {
            this.bind(context, jndiReferenceBinding, useRebind);
        }
        for (Set set : bindings.getBusinessRemoteBindings().values()) {
            for (JndiReferenceBinding binding : set) {
                this.bind(context, binding, useRebind);
            }
        }
        if (bindLocals) {
            for (JndiReferenceBinding jndiReferenceBinding : bindings.getDefaultLocalBindings()) {
                this.bind(context, jndiReferenceBinding, useRebind);
            }
            for (JndiReferenceBinding jndiReferenceBinding : bindings.getHomeLocalBindings()) {
                this.bind(context, jndiReferenceBinding, useRebind);
            }
            for (Set set : bindings.getBusinessLocalBindings().values()) {
                for (JndiReferenceBinding binding : set) {
                    this.bind(context, binding, useRebind);
                }
            }
        }
    }

    protected void bind(Context context, JndiReferenceBinding binding, boolean useRebind) {
        if (binding != null) {
            if (useRebind) {
                this.rebind(context, binding.getJndiName(), binding.getReference());
            } else {
                this.bind(context, binding.getJndiName(), binding.getReference());
            }
        }
    }

    protected void bind(Context context, String address, Reference ref) {
        try {
            Util.bind((Context)context, (String)address, (Object)ref);
            log.debug((Object)("Bound " + ref.getClass().getName() + " into JNDI at \"" + address + "\""));
        }
        catch (NamingException e) {
            throw new RuntimeException("Could not bind " + ref + " into JNDI at \"" + address + "\"", e);
        }
    }

    protected void rebind(Context context, String address, Reference ref) {
        try {
            Util.rebind((Context)context, (String)address, (Object)ref);
            log.debug((Object)("Bound " + ref.getClass().getName() + " into JNDI at \"" + address + "\""));
        }
        catch (NamingException e) {
            throw new RuntimeException("Could not bind " + ref + " into JNDI at \"" + address + "\"", e);
        }
    }

    protected void unbind(Context context, String address) {
        try {
            Util.unbind((Context)context, (String)address);
        }
        catch (NameNotFoundException nnfe) {
        }
        catch (NamingException e) {
            throw new RuntimeException("Could not unbind \"" + address + "\" from JNDI", e);
        }
    }

    protected boolean isHomeAndBusinessBoundTogether(JBossSessionBeanMetaData smd, boolean isLocal) {
        boolean bindTogether = false;
        if (isLocal) {
            if (smd.getLocalHome() == null) {
                return false;
            }
            bindTogether = smd.getLocalJndiName().equals(smd.getLocalHomeJndiName());
        } else {
            if (smd.getHome() == null) {
                return false;
            }
            bindTogether = smd.getJndiName().equals(smd.getHomeJndiName());
        }
        return bindTogether;
    }

    protected RefAddr createRemotingRefAddr(JBossSessionBeanMetaData smd) {
        List bindings = smd.getRemoteBindings();
        assert (bindings != null && bindings.size() > 0) : "Remote Bindings are required and none are present";
        RemoteBindingMetaData remoteBinding = (RemoteBindingMetaData)smd.getRemoteBindings().get(0);
        String url = remoteBinding.getClientBindUrl();
        assert (url != null && url.trim().toString().length() != 0) : InvokerLocator.class.getSimpleName() + " URL must be defined, and is unspecified";
        StringRefAddr refAddr = new StringRefAddr("Remoting Host URL", url);
        return refAddr;
    }

    public String getProxyFactoryRegistryKey(JBossSessionBeanMetaData md, boolean isLocal) {
        String suffix = null;
        suffix = isLocal ? md.getLocalJndiName() : md.getJndiName();
        assert (suffix != null && !suffix.equals("")) : ProxyFactory.class.getSimpleName() + " key prefix for binding to registry is noy specified";
        String key = KEY_PREFIX_PROXY_FACTORY_REGISTRY + suffix;
        return key;
    }

    protected String getHumanReadableListOfInterfacesInRefAddrs(List<RefAddr> refAddrs) {
        StringBuffer defaultRemotes = new StringBuffer();
        int remotesCount = 0;
        int interfaceCount = 0;
        for (RefAddr refAddr : refAddrs) {
            ++remotesCount;
            String refAddrType = refAddr.getType();
            if (!this.isRefAddrTypeEjbInterface(refAddrType)) continue;
            if (interfaceCount > 0) {
                defaultRemotes.append(", ");
            }
            defaultRemotes.append(refAddr.getContent());
            ++interfaceCount;
        }
        return defaultRemotes.toString();
    }

    private boolean isRefAddrTypeEjbInterface(String refAddrType) {
        return refAddrType.equals("Local Business Interface") || refAddrType.equals("Remote Business Interface") || refAddrType.equals("EJB 2.x Local Home Interface") || refAddrType.equals("EJB 2.x Remote Home Interface");
    }

    protected void registerProxyFactory(String name, ProxyFactory factory, JBossEnterpriseBeanMetaData smd) {
        log.debug((Object)("Registering " + factory + " under key \"" + name + "\"..."));
        try {
            Ejb3RegistrarLocator.locateRegistrar().bind((Object)name, (Object)factory);
        }
        catch (DuplicateBindException e) {
            throw new RuntimeException("Could not register " + factory + " under an already registered key, \"" + name + "\"", e);
        }
    }

    protected void deregisterProxyFactory(String name) {
        log.debug((Object)("Deregistering " + ProxyFactory.class.getSimpleName() + " under name \"" + name + "\""));
        Object obj = Ejb3RegistrarLocator.locateRegistrar().lookup((Object)name);
        assert (obj != null) : ProxyFactory.class.getSimpleName() + " was expected registered under name \"" + name + "\", but sws not found.";
        assert (obj instanceof ProxyFactory) : "Expected " + ProxyFactory.class.getName() + " bound under name \"" + name + "\", but was instead: " + obj;
        Ejb3RegistrarLocator.locateRegistrar().unbind((Object)name);
    }

    public String getSessionProxyObjectFactoryType() {
        return this.sessionProxyObjectFactoryType;
    }

    public void setSessionProxyObjectFactoryType(String sessionProxyObjectFactoryType) {
        this.sessionProxyObjectFactoryType = sessionProxyObjectFactoryType;
    }

    static {
        StringBuffer sb = new StringBuffer();
        sb.append("socket://");
        String bindAddress = System.getProperty("jboss.bind.address");
        if (bindAddress == null) {
            bindAddress = "0.0.0.0";
        }
        sb.append(bindAddress);
        sb.append(":3873");
        DEFAULT_CLIENT_BINDING = sb.toString();
    }
}

