/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.handler.session.stateful;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import org.jboss.aop.advice.Interceptor;
import org.jboss.ejb3.proxy.container.InvokableContext;
import org.jboss.ejb3.proxy.handler.session.SessionSpecProxyInvocationHandlerBase;
import org.jboss.ejb3.proxy.intf.StatefulSessionProxy;
import org.jboss.ejb3.proxy.invocation.InvokableContextStatefulRemoteProxyInvocationHack;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.util.NotImplementedException;

public abstract class StatefulProxyInvocationHandlerBase
extends SessionSpecProxyInvocationHandlerBase
implements StatefulSessionProxy,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(StatefulProxyInvocationHandlerBase.class);
    private Serializable sessionId;

    public StatefulProxyInvocationHandlerBase(String containerName, String containerGuid, Interceptor[] interceptors, String businessInterfaceType) {
        super(containerName, containerGuid, interceptors, businessInterfaceType);
    }

    public Serializable getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(Serializable sessionId) {
        this.sessionId = sessionId;
    }

    protected boolean invokeEquals(Object proxy, Object argument) {
        if (!argument.getClass().equals(proxy.getClass())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(argument + " is not equal to " + proxy + " as they are different types"));
            }
            return false;
        }
        StatefulProxyInvocationHandlerBase proxyHandler = this.getInvocationHandler(proxy);
        InvocationHandler argumentHandler = Proxy.getInvocationHandler(argument);
        if (!(argumentHandler instanceof StatefulProxyInvocationHandlerBase)) {
            return false;
        }
        StatefulProxyInvocationHandlerBase sHandler = proxyHandler;
        StatefulProxyInvocationHandlerBase sArgument = (StatefulProxyInvocationHandlerBase)argumentHandler;
        String proxyContainerName = sHandler.getContainerName();
        assert (proxyContainerName != null) : "Container Name for " + sHandler + " was not set and is required";
        if (!proxyContainerName.equals(sArgument.getContainerName())) {
            return false;
        }
        Serializable sessionId = sHandler.getSessionId();
        assert (sessionId != null) : "Required Session ID is not present in " + proxy;
        boolean equal = sessionId.equals(sArgument.getSessionId());
        log.debug((Object)("SFSB Equality Check for " + sHandler.getSessionId() + " and " + sArgument.getSessionId() + " = " + equal));
        return equal;
    }

    protected int invokeHashCode(Object proxy) {
        StatefulProxyInvocationHandlerBase handler = this.getInvocationHandler(proxy);
        String unique = handler.getContainerName() + handler.getBusinessInterfaceType() + handler.getSessionId();
        return unique.hashCode();
    }

    protected InvokableContext createRemoteProxyToContainer(String url) {
        InvokerLocator locator = null;
        try {
            locator = new InvokerLocator(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not create " + InvokerLocator.class.getSimpleName() + " to url \"" + url + "\"", e);
        }
        Interceptor[] interceptors = this.getInterceptors();
        String containerName = this.getContainerName();
        assert (containerName != null && containerName.trim().length() > 0) : "Container Name must be set";
        InvokableContextStatefulRemoteProxyInvocationHack handler = new InvokableContextStatefulRemoteProxyInvocationHack(this.getContainerName(), this.getContainerGuid(), locator, interceptors, this.getSessionId());
        Class[] interfaces = new Class[]{InvokableContext.class};
        InvokableContext container = (InvokableContext)Proxy.newProxyInstance(InvokableContext.class.getClassLoader(), interfaces, (InvocationHandler)((Object)handler));
        return container;
    }

    protected StatefulProxyInvocationHandlerBase getInvocationHandler(Object proxy) {
        InvocationHandler handler = Proxy.getInvocationHandler(proxy);
        assert (handler instanceof StatefulProxyInvocationHandlerBase) : "Expected " + InvocationHandler.class.getSimpleName() + " of type " + StatefulProxyInvocationHandlerBase.class.getName() + ", but instead was " + handler;
        return (StatefulProxyInvocationHandlerBase)handler;
    }

    public Object getAsynchronousProxy(Object proxy) {
        throw new NotImplementedException("ALR");
    }
}

