/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.factory.session;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.common.lang.ClassHelper;
import org.jboss.ejb3.common.string.StringUtils;
import org.jboss.ejb3.proxy.factory.ProxyFactoryBase;
import org.jboss.ejb3.proxy.factory.session.SessionProxyFactory;
import org.jboss.ejb3.proxy.factory.session.SessionSpecProxyFactory;
import org.jboss.ejb3.proxy.handler.session.SessionProxyInvocationHandler;
import org.jboss.ejb3.proxy.intf.SessionProxy;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SessionProxyFactoryBase
extends ProxyFactoryBase
implements SessionSpecProxyFactory {
    private static final Logger log = Logger.getLogger(SessionProxyFactoryBase.class);
    private JBossSessionBeanMetaData metadata;
    private Constructor<?> constructorProxyDefault;
    private Map<String, Constructor<?>> constructorsProxySpecificBusinessInterface;
    private Constructor<?> constructorProxyHome;
    private Constructor<?> constructorProxyEjb2x;

    public SessionProxyFactoryBase(String name, String containerName, String containerGuid, JBossSessionBeanMetaData metadata, ClassLoader classloader, Advisor advisor) {
        super(name, containerName, containerGuid, classloader, advisor);
        this.setMetadata(metadata);
        this.setConstructorsProxySpecificBusinessInterface(new HashMap());
    }

    @Override
    public Object createProxyHome() {
        SessionProxyInvocationHandler handler = this.createHomeInvocationHandler();
        try {
            return this.getConstructorProxyHome().newInstance(handler);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not create Home Proxy for " + this.getMetadata().getEjbName(), t);
        }
    }

    @Override
    public Object createProxyDefault() {
        Constructor<?> constructor = this.getConstructorProxyDefault();
        assert (constructor != null) : "Constructor for Default Proxy was null; perhaps the " + SessionProxyFactory.class.getSimpleName() + " was not properly started?";
        SessionProxyInvocationHandler handler = this.createBusinessDefaultInvocationHandler();
        try {
            return constructor.newInstance(handler);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not create the Default Proxy for " + this.getMetadata().getEjbName(), t);
        }
    }

    @Override
    public Object createProxyBusiness(String businessInterfaceName) {
        assert (businessInterfaceName != null && businessInterfaceName.trim().length() > 0) : "Required business interface type name was not specified";
        try {
            Constructor<?> constructor = this.getConstructorsProxySpecificBusinessInterface().get(businessInterfaceName.trim());
            assert (constructor != null) : "No business proxy constructor for \"" + businessInterfaceName + "\" was found; not created at start() properly?  Bad value bound as RefAddr in JNDI?";
            SessionProxyInvocationHandler handler = this.createBusinessInterfaceSpecificInvocationHandler(businessInterfaceName);
            Object proxy = constructor.newInstance(handler);
            return proxy;
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not create the EJB3 Business Proxy implementing \"" + businessInterfaceName + "\" for " + this.getMetadata().getEjbName(), t);
        }
    }

    @Override
    public Object createProxyEjb2x() {
        SessionProxyInvocationHandler handler = this.createEjb2xComponentInterfaceInvocationHandler();
        try {
            return this.getConstructorProxyEjb2x().newInstance(handler);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not create the EJB2.x Proxy for " + this.getMetadata().getEjbName(), t);
        }
    }

    @Override
    public void start() throws Exception {
        String homeInterfaceType;
        boolean hasHomeInterface;
        boolean hasBusinessInterfaces;
        super.start();
        Set<String> businessInterfaceTypes = this.getBusinessInterfaceTypes();
        HashSet businessInterfaceClasses = new HashSet();
        boolean bl = hasBusinessInterfaces = businessInterfaceTypes != null && businessInterfaceTypes.size() > 0;
        if (hasBusinessInterfaces) {
            for (String businessInterfaceType : businessInterfaceTypes) {
                Class<?> businessInterface = null;
                try {
                    businessInterface = this.getClassLoader().loadClass(businessInterfaceType);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException("Could not find specified Session Bean Business Interface \"" + businessInterfaceType + "\" in " + ClassLoader.class.getSimpleName() + " for EJB " + this.getMetadata().getEjbName(), cnfe);
                }
                businessInterfaceClasses.add(businessInterface);
                HashSet businessInterfaces = new HashSet();
                businessInterfaces.add(businessInterface);
                Constructor<?> businessInterfaceConstructor = this.createProxyConstructor(businessInterfaces, this.getClassLoader());
                log.debug((Object)("Created Session Bean Business Interface-Specific Proxy Constructor implementing \"" + businessInterfaceType + "\""));
                this.getConstructorsProxySpecificBusinessInterface().put(businessInterfaceType, businessInterfaceConstructor);
            }
        }
        boolean bl2 = hasHomeInterface = (homeInterfaceType = this.getHomeType()) != null && !homeInterfaceType.equals("");
        if (!hasHomeInterface && !hasBusinessInterfaces) {
            throw new RuntimeException("Cannot deploy EJB " + this.getMetadata().getEjbName() + " as it has no EJB3 (Business Interface) or EJB2.x (Home Interface) Views Defined.");
        }
        Class<?> homeInterfaceClass = null;
        if (hasHomeInterface) {
            try {
                homeInterfaceClass = this.getClassLoader().loadClass(homeInterfaceType);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not find specified Session Bean Home Interface \"" + homeInterfaceType + "\" in " + ClassLoader.class.getSimpleName() + " for EJB " + this.getMetadata().getEjbName(), cnfe);
            }
            HashSet homeInterfaces = new HashSet();
            homeInterfaces.add(homeInterfaceClass);
            Constructor<?> homeConstructor = this.createProxyConstructor(homeInterfaces, this.getClassLoader());
            log.debug((Object)("Created Session Bean Home Proxy Constructor implementing \"" + homeInterfaceType + "\""));
            this.setConstructorProxyHome(homeConstructor);
        }
        HashSet defaultProxyInterfaces = new HashSet();
        if (hasBusinessInterfaces) {
            defaultProxyInterfaces.addAll(businessInterfaceClasses);
        }
        if (hasHomeInterface && this.getMetadata().getJndiName().equals(this.getMetadata().getHomeJndiName())) {
            defaultProxyInterfaces.add(homeInterfaceClass);
        }
        Constructor<?> businessInterfacesConstructor = this.createProxyConstructor(defaultProxyInterfaces, this.getClassLoader());
        log.debug((Object)("Created Session Bean Default EJB3 Business Proxy Constructor implementing " + defaultProxyInterfaces));
        this.setConstructorProxyDefault(businessInterfacesConstructor);
        if (hasHomeInterface) {
            String ejb2xDeclaredType;
            HashSet ejb2xInterfaces = new HashSet();
            Set<Class<?>> homeReturnTypes = this.getReturnTypesFromCreateMethods(homeInterfaceClass);
            if (homeReturnTypes != null) {
                ejb2xInterfaces.addAll(homeReturnTypes);
            }
            if ((ejb2xDeclaredType = StringUtils.adjustWhitespaceStringToNull((String)this.getEjb2xInterfaceType())) != null) {
                Class<?> ejb2xInterface = null;
                try {
                    ejb2xInterface = this.getClassLoader().loadClass(ejb2xDeclaredType);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException("Could not find specified Session Bean EJB2.x Interface \"" + ejb2xDeclaredType + "\" in " + ClassLoader.class.getSimpleName() + " for EJB " + this.getMetadata().getEjbName(), cnfe);
                }
                ejb2xInterfaces.add(ejb2xInterface);
            }
            Constructor<?> ejb2xConstructor = this.createProxyConstructor(ejb2xInterfaces, this.getClassLoader());
            log.debug((Object)("Created Session Bean EJB2x Proxy Constructor implementing " + ejb2xInterfaces));
            this.setConstructorProxyEjb2x(ejb2xConstructor);
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
    }

    @Override
    protected Set<Class<?>> getCommonProxyInterfaces() {
        Set<Class<?>> interfaces = super.getCommonProxyInterfaces();
        interfaces.add(SessionProxy.class);
        return interfaces;
    }

    @Deprecated
    protected Set<Class<?>> getReturnTypesFromCreateMethods(Class<?> homeInterface, boolean isStateless) {
        assert (EJBHome.class.isAssignableFrom(homeInterface) || EJBLocalHome.class.isAssignableFrom(homeInterface));
        if (!EJBHome.class.isAssignableFrom(homeInterface) && !EJBLocalHome.class.isAssignableFrom(homeInterface)) {
            throw new RuntimeException("Declared EJB 2.1 Home Interface " + homeInterface.getName() + " does not extend " + EJBHome.class.getName() + " or " + EJBLocalHome.class.getName() + " as required by EJB 3.0 Core Specification 4.6.8 and 4.6.10");
        }
        HashSet types = new HashSet();
        ArrayList<Method> createMethods = null;
        if (isStateless) {
            String specViolationErrorMessage = "EJB 3.0 Specification Violation (4.6.8 Bullet 4, 4.6.10 Bullet 4): \"A stateless session bean must define exactly one create method with no arguments.\"; found in " + homeInterface.getName();
            createMethods = new ArrayList<Method>();
            try {
                createMethods.add(homeInterface.getMethod("create", new Class[0]));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(specViolationErrorMessage);
            }
            if (createMethods.size() > 1) {
                throw new RuntimeException(specViolationErrorMessage);
            }
        } else {
            createMethods = ClassHelper.getAllMethodsByPrefix(homeInterface, (String)"create");
        }
        if (createMethods.size() == 0) {
            throw new RuntimeException("EJB 3.0 Core Specification Violation (4.6.8 Bullet 5): EJB2.1 Home Interface " + homeInterface + " does not declare a 'create<METHOD>' method");
        }
        for (Method method : createMethods) {
            types.add(method.getReturnType());
        }
        return types;
    }

    protected abstract Set<String> getBusinessInterfaceTypes();

    protected abstract String getHomeType();

    protected abstract String getEjb2xInterfaceType();

    protected abstract Set<Class<?>> getReturnTypesFromCreateMethods(Class<?> var1);

    protected abstract SessionProxyInvocationHandler createBusinessInterfaceSpecificInvocationHandler(String var1);

    protected abstract SessionProxyInvocationHandler createBusinessDefaultInvocationHandler();

    protected abstract SessionProxyInvocationHandler createEjb2xComponentInterfaceInvocationHandler();

    protected abstract SessionProxyInvocationHandler createHomeInvocationHandler();

    public JBossSessionBeanMetaData getMetadata() {
        return this.metadata;
    }

    protected void setMetadata(JBossSessionBeanMetaData metadata) {
        this.metadata = metadata;
    }

    protected Constructor<?> getConstructorProxyDefault() {
        return this.constructorProxyDefault;
    }

    protected void setConstructorProxyDefault(Constructor<?> constructorProxyDefault) {
        this.constructorProxyDefault = constructorProxyDefault;
    }

    protected Map<String, Constructor<?>> getConstructorsProxySpecificBusinessInterface() {
        return this.constructorsProxySpecificBusinessInterface;
    }

    protected void setConstructorsProxySpecificBusinessInterface(Map<String, Constructor<?>> constructorsProxySpecificBusinessInterface) {
        this.constructorsProxySpecificBusinessInterface = constructorsProxySpecificBusinessInterface;
    }

    protected Constructor<?> getConstructorProxyHome() {
        return this.constructorProxyHome;
    }

    protected void setConstructorProxyHome(Constructor<?> constructorProxyHome) {
        this.constructorProxyHome = constructorProxyHome;
    }

    protected Constructor<?> getConstructorProxyEjb2x() {
        return this.constructorProxyEjb2x;
    }

    protected void setConstructorProxyEjb2x(Constructor<?> constructorProxyEjb2x) {
        this.constructorProxyEjb2x = constructorProxyEjb2x;
    }
}

